/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.psi.SassScssPlaceholderSelector;
import org.jetbrains.plugins.scss.psi.stubs.ScssPlaceholderSelectorIndex;

public class PlaceholderSelectorProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/sass/completion/PlaceholderSelectorProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/completion/PlaceholderSelectorProvider", "addCompletions"));
        }
        PsiElement originalElement = PsiTreeUtil.getParentOfType((PsiElement)parameters.getOriginalPosition(), (Class[])new Class[]{CssSelector.class, SassScssPlaceholderSelector.class});
        PsiElement position = parameters.getPosition();
        PsiFile originalFile = parameters.getOriginalFile();
        Project project = position.getProject();
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)originalFile, (PsiElement)position, (boolean)false);
        for (String name : StubIndex.getInstance().getAllKeys(ScssPlaceholderSelectorIndex.KEY, project)) {
            if (name.isEmpty()) continue;
            ScssPlaceholderSelectorIndex.process(name, project, scope, (Processor<? super SassScssPlaceholderSelector>)((Processor)selector -> {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/completion/PlaceholderSelectorProvider", "lambda$addCompletions$0"));
                }
                if (selector != originalElement) {
                    boolean validResult = importedFiles.contains(selector.getContainingFile().getVirtualFile());
                    result.addElement(SASSSCSSLangUtil.createPlaceholderSelectorLookup(selector, (PsiElement)selector, validResult));
                }
                return true;
            }));
            CssIndexUtil.processAmpersandSelectors((Project)project, (GlobalSearchScope)scope, ampresandSelector -> {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/completion/PlaceholderSelectorProvider", "lambda$addCompletions$2"));
                }
                if (ampresandSelector != originalElement) {
                    Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)ampresandSelector);
                    ampresandSelector.processAmpersandEvaluatedSelectors(ampresandSelector, language, selector -> {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/completion/PlaceholderSelectorProvider", "lambda$null$1"));
                        }
                        for (CssSimpleSelector simpleSelector : selector.getSimpleSelectors()) {
                            for (CssSelectorSuffix selectorSuffix : simpleSelector.getSelectorSuffixes()) {
                                if (!(selectorSuffix instanceof SassScssPlaceholderSelector)) continue;
                                boolean validResult = importedFiles.contains(ampresandSelector.getContainingFile().getVirtualFile());
                                result.addElement(SASSSCSSLangUtil.createPlaceholderSelectorLookup((SassScssPlaceholderSelector)selectorSuffix, (PsiElement)ampresandSelector, validResult));
                            }
                        }
                        return true;
                    });
                }
                return true;
            });
        }
    }
}

