/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.intellij.application.options.ModuleAwareProjectConfigurable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;

public class CompassConfigurableProvider
extends ConfigurableProvider {
    public static final String HELP_TOPIC = "compass.support";
    @NotNull
    private final Project myProject;

    public CompassConfigurableProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/sass/extensions/compass/CompassConfigurableProvider", "<init>"));
        }
        this.myProject = project;
    }

    @Nullable
    public Configurable createConfigurable() {
        return new ModuleAwareProjectConfigurable(this.myProject, SASSBundle.message("compass.support.configurable.name"), HELP_TOPIC){

            @NotNull
            protected UnnamedConfigurable createModuleConfigurable(Module module) {
                Configurable configurable = SassRubyIntegrationHelper.getInstance().createCompassConfigurable(module, true);
                if (configurable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassConfigurableProvider$1", "createModuleConfigurable"));
                }
                return configurable;
            }
        };
    }
}

