/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.SassExtension;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfoImpl;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.sass.extensions.compass.CompassImportPathRegistrationWatcher;
import org.jetbrains.plugins.sass.extensions.compass.CompassImportPathRegistrationWatcherImpl;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettings;
import org.jetbrains.plugins.sass.extensions.compass.CompassUtil;

public class CompassSassExtension
extends SassExtension
implements CompassImportPathRegistrationWatcher.ImportPathsListener {
    private static final Set<String> APPROPRIATE_MODULE_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"Compass::SassExtensions::Functions", "Compass::Core::SassExtensions::Functions"});
    private static final Map<String, SassExtensionFunctionInfo> CUSTOM_FUNCTIONS = ContainerUtil.newHashMap((Pair)Pair.pair((Object)"_webkit", (Object)new SassExtensionFunctionInfoImpl("-webkit", "$arg, ...", "This is a shortcut for calling prefix(-webkit, $arg, ...).", "compass", null)), (Pair[])new Pair[]{Pair.pair((Object)"_o", (Object)new SassExtensionFunctionInfoImpl("-o", "$arg, ...", "This is a shortcut for calling prefix(-o, $arg, ...).", "compass", null)), Pair.pair((Object)"_ms", (Object)new SassExtensionFunctionInfoImpl("-ms", "$arg, ...", "This is a shortcut for calling prefix(-ms, $arg, ...).", "compass", null)), Pair.pair((Object)"_svg", (Object)new SassExtensionFunctionInfoImpl("-svg", "$arg, ...", "This is a shortcut for calling prefix(-svg, $arg, ...).", "compass", null)), Pair.pair((Object)"_pie", (Object)new SassExtensionFunctionInfoImpl("-pie", "$arg, ...", "This is a shortcut for calling prefix(-pie, $arg, ...).", "compass", null)), Pair.pair((Object)"_css2", (Object)new SassExtensionFunctionInfoImpl("-css2", "$arg, ...", "This is a shortcut for calling prefix(-css2, $arg, ...).", "compass", null)), Pair.pair((Object)"_owg", (Object)new SassExtensionFunctionInfoImpl("-owg", "$arg, ...", "This is a shortcut for calling prefix(-owg, $arg, ...).", "compass", null)), Pair.pair((Object)"_moz", (Object)new SassExtensionFunctionInfoImpl("-moz", "$arg, ...", "This is a shortcut for calling prefix(-moz, $arg, ...).", "compass", null))});

    @Override
    public String getName() {
        return SASSBundle.message("compass.gem.name");
    }

    @Override
    protected boolean isAvailableInModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension", "isAvailableInModule"));
        }
        if (module.isDisposed() || SassRubyIntegrationHelper.getInstance().hasRubyPlugin()) {
            return false;
        }
        CompassSettings compassSettings = CompassSettings.getInstance(module);
        return compassSettings != null && compassSettings.isCompassSupportEnabled();
    }

    @Override
    protected void startActivity(@NotNull Module module) {
        CompassImportPathRegistrationWatcherImpl compassImportPathsWatcher;
        CompassSettings settings;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension", "startActivity"));
        }
        if (!module.isDisposed() && (settings = CompassSettings.getInstance(module)) != null && settings.isCompassSupportEnabled() && (compassImportPathsWatcher = CompassImportPathRegistrationWatcherImpl.getInstance(module)) != null) {
            compassImportPathsWatcher.subscribe(this, !settings.getCompassConfigPath().isEmpty());
        }
    }

    @Override
    protected void stopActivity(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension", "stopActivity"));
        }
        CompassImportPathRegistrationWatcherImpl watcher = CompassImportPathRegistrationWatcherImpl.getInstance(module);
        if (watcher != null) {
            boolean wasStarted = watcher.isStarted();
            Disposer.dispose((Disposable)watcher);
            if (wasStarted) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (module == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension", "lambda$stopActivity$0"));
                    }
                    CompassUtil.removeCompassLibraryIfNeeded(module);
                }, ModalityState.NON_MODAL);
            }
        }
    }

    @Override
    @NotNull
    public Collection<SassExtensionFunctionInfo> getCustomFunctions() {
        Collection<SassExtensionFunctionInfo> collection = CUSTOM_FUNCTIONS.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension", "getCustomFunctions"));
        }
        return collection;
    }

    @Override
    @Nullable
    public SassExtensionFunctionInfo findCustomFunctionByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension", "findCustomFunctionByName"));
        }
        return CUSTOM_FUNCTIONS.get(name);
    }

    @NotNull
    public Set<String> getRubyModulesWithFunctionExtensions() {
        Set<String> set = APPROPRIATE_MODULE_NAMES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension", "getRubyModulesWithFunctionExtensions"));
        }
        return set;
    }

    @Override
    public void pathsChanged(@NotNull Module module, @NotNull Set<String> newImportPaths) {
        CompassSettings compassSettings;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension", "pathsChanged"));
        }
        if (newImportPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newImportPaths", "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension", "pathsChanged"));
        }
        if (!module.isDisposed() && !newImportPaths.equals(ContainerUtil.newHashSet((compassSettings = CompassSettings.getInstance(module)).getImportPaths()))) {
            compassSettings.setImportPaths(ContainerUtil.newArrayList(newImportPaths));
            ApplicationManager.getApplication().invokeLater(() -> CompassUtil.updateCompassLibraries(compassSettings));
        }
    }

    @Override
    @NotNull
    public Collection<? extends VirtualFile> getStylesheetsRoots(@NotNull Module module) {
        List<String> importPaths;
        CompassSettings compassSettings;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension", "getStylesheetsRoots"));
        }
        if (!module.isDisposed() && (compassSettings = CompassSettings.getInstance(module)) != null && compassSettings.isCompassSupportEnabled() && !(importPaths = compassSettings.getImportPaths()).isEmpty()) {
            LinkedList result = ContainerUtil.newLinkedList();
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            for (String path : importPaths) {
                VirtualFile vfile = virtualFileManager.findFileByUrl(VfsUtilCore.pathToUrl((String)path));
                if (vfile == null) continue;
                result.add(vfile);
            }
            LinkedList linkedList = result;
            if (linkedList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension", "getStylesheetsRoots"));
            }
            return linkedList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassSassExtension", "getStylesheetsRoots"));
        }
        return list;
    }
}

