/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.scss.SCSSElementTypes;
import org.jetbrains.plugins.scss.psi.SASSSCSSElementVisitor;
import org.jetbrains.plugins.scss.psi.SCSSElementGenerator;
import org.jetbrains.plugins.scss.psi.SassScssRuleset;
import org.jetbrains.plugins.scss.psi.SassScssStatement;
import org.jetbrains.plugins.scss.references.SassScssMixinReference;

public class SassScssInclude
extends CompositePsiElement
implements PsiNameIdentifierOwner,
SassScssStatement,
SassScssRuleset {
    protected SassScssInclude() {
        super(SCSSElementTypes.SCSS_INCLUDE);
    }

    public String getName() {
        PsiElement namedElement = this.getNameIdentifier();
        return namedElement != null ? namedElement.getText() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/scss/psi/SassScssInclude", "setName"));
        }
        PsiElement nameIdentifier = this.getNameIdentifier();
        if (nameIdentifier != null) {
            PsiElement includeName = SCSSElementGenerator.createIncludeName(this.getProject(), name);
            nameIdentifier.replace(includeName);
        }
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode[] nameVariants = this.getChildren(CssElementTypes.NAME_TOKEN_TYPES);
        if (nameVariants.length > 0) {
            return nameVariants[0].getPsi();
        }
        return null;
    }

    public int getTextOffset() {
        PsiElement element = this.getNameIdentifier();
        return element != null ? element.getTextOffset() : super.getTextOffset();
    }

    public PsiReference getReference() {
        return this.getNameIdentifier() != null ? new SassScssMixinReference(this) : null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/scss/psi/SassScssInclude", "accept"));
        }
        if (visitor instanceof SASSSCSSElementVisitor) {
            ((SASSSCSSElementVisitor)visitor).visitInclude(this);
            return;
        }
        super.accept(visitor);
    }
}

