/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.spring.websocket.model.messaging.SpringMessagingModel;
import com.intellij.spring.websocket.model.messaging.SpringMessagingType;
import com.intellij.spring.websocket.model.messaging.UrlPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringMessagingReference
extends PsiReferenceBase.Poly<PsiElement> {
    @NotNull
    private final List<SpringMessagingModel.Variant> myVariants;
    private final int myPartIndex;
    @NotNull
    private final SpringMessagingType[] myMessagingTypes;

    public SpringMessagingReference(@NotNull PsiElement element, @NotNull SpringMessagingType[] messagingTypes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/websocket/references/SpringMessagingReference", "<init>"));
        }
        if (messagingTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagingTypes", "com/intellij/spring/websocket/references/SpringMessagingReference", "<init>"));
        }
        super(element, true);
        this.myVariants = Collections.emptyList();
        this.myPartIndex = -1;
        this.myMessagingTypes = messagingTypes;
    }

    private SpringMessagingReference(@NotNull PsiElement element, @NotNull List<SpringMessagingModel.Variant> variants, int partIndex, @NotNull TextRange textRange, @NotNull SpringMessagingType[] messagingTypes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/websocket/references/SpringMessagingReference", "<init>"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/spring/websocket/references/SpringMessagingReference", "<init>"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/spring/websocket/references/SpringMessagingReference", "<init>"));
        }
        if (messagingTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagingTypes", "com/intellij/spring/websocket/references/SpringMessagingReference", "<init>"));
        }
        super(element, textRange, variants.get((int)0).parts[partIndex].getPsiElement() == null);
        this.myVariants = variants;
        this.myMessagingTypes = messagingTypes;
        this.myPartIndex = partIndex;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (this.myVariants.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/references/SpringMessagingReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List elements = ContainerUtil.mapNotNull(this.myVariants, variant -> {
            UrlPointer pointer = variant.parts[this.myPartIndex];
            return pointer == null ? null : pointer.getPsiElement();
        });
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)elements);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/references/SpringMessagingReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Nullable
    private SpringMessagingModel getModel() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        return module == null ? null : new SpringMessagingModel(module);
    }

    @NotNull
    public Object[] getVariants() {
        SpringMessagingModel model = this.getModel();
        if (model == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/references/SpringMessagingReference", "getVariants"));
            }
            return EMPTY_ARRAY;
        }
        Object[] objectArray = ContainerUtil.map2Array(model.getUrls(this.myMessagingTypes), LookupElement.class, variant -> {
            PsiElement resolveElement = variant.urlDefinition.getPsiElement();
            LookupElementBuilder builder = resolveElement != null ? LookupElementBuilder.create((Object)resolveElement, (String)variant.presentation).withTypeText(FileUtil.getNameWithoutExtension((String)resolveElement.getContainingFile().getName())) : LookupElementBuilder.create((String)variant.presentation);
            return builder;
        });
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/references/SpringMessagingReference", "getVariants"));
        }
        return objectArray;
    }

    public static SpringMessagingReference[] createReferences(@NotNull PsiElement element, @NotNull List<SpringMessagingModel.Variant> variants, @NotNull SpringMessagingType[] messagingTypes) {
        String classPrefixUrl;
        int startOffset;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/websocket/references/SpringMessagingReference", "createReferences"));
        }
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/spring/websocket/references/SpringMessagingReference", "createReferences"));
        }
        if (messagingTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messagingTypes", "com/intellij/spring/websocket/references/SpringMessagingReference", "createReferences"));
        }
        ArrayList<SpringMessagingReference> result = new ArrayList<SpringMessagingReference>();
        int previousPartEndIndex = -1;
        String elementText = element.getText();
        SpringMessagingModel.Variant variant = variants.get(0);
        String appPrefixUrl = variant.appPrefix.getUrl();
        if (elementText.indexOf(appPrefixUrl, 1) != 1) {
            return new SpringMessagingReference[]{new SpringMessagingReference(element, messagingTypes)};
        }
        previousPartEndIndex = appPrefixUrl.length() + 1;
        result.add(new SpringMessagingReference(element, variants, 0, new TextRange(1, previousPartEndIndex), messagingTypes));
        if (variant.classPrefix != null && (startOffset = elementText.indexOf(classPrefixUrl = variant.classPrefix.getUrl(), previousPartEndIndex)) >= 0) {
            previousPartEndIndex = startOffset + classPrefixUrl.length();
            result.add(new SpringMessagingReference(element, variants, 1, new TextRange(startOffset, previousPartEndIndex), messagingTypes));
        }
        result.add(new SpringMessagingReference(element, variants, 2, new TextRange(1, elementText.length() - 1), messagingTypes));
        return result.toArray(new SpringMessagingReference[result.size()]);
    }
}

