/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.facet.ui;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.StrutsIcons;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.facet.StrutsFacetConfiguration;
import com.intellij.struts2.facet.ui.FileSetEditor;
import com.intellij.struts2.facet.ui.StrutsConfigsSearcher;
import com.intellij.struts2.facet.ui.StrutsFileSet;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSetConfigurationTab
extends FacetEditorTab
implements Disposable {
    private JPanel myPanel;
    private SimpleTree myTree;
    private AnActionButton myRemoveButton;
    private AnActionButton myEditButton;
    private JPanel myTreePanel;
    private final SimpleTreeBuilder myBuilder;
    private final SimpleNode myRootNode;
    private final TreeExpander myTreeExpander;
    private final StrutsConfigsSearcher myConfigsSearcher;
    private final StrutsFacetConfiguration originalConfiguration;
    private final Module module;
    private final Set<StrutsFileSet> myBuffer;
    private boolean myModified;

    public FileSetConfigurationTab(final @NotNull StrutsFacetConfiguration strutsFacetConfiguration, final @NotNull FacetEditorContext facetEditorContext) {
        if (strutsFacetConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strutsFacetConfiguration", "com/intellij/struts2/facet/ui/FileSetConfigurationTab", "<init>"));
        }
        if (facetEditorContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetEditorContext", "com/intellij/struts2/facet/ui/FileSetConfigurationTab", "<init>"));
        }
        this.$$$setupUI$$$();
        this.myRootNode = new SimpleNode(){

            public SimpleNode[] getChildren() {
                ArrayList<FileSetNode> nodes = new ArrayList<FileSetNode>(FileSetConfigurationTab.this.myBuffer.size());
                for (StrutsFileSet entry : FileSetConfigurationTab.this.myBuffer) {
                    if (entry.isRemoved()) continue;
                    FileSetNode setNode = new FileSetNode(entry);
                    nodes.add(setNode);
                }
                return (SimpleNode[])ArrayUtil.toObjectArray(nodes, SimpleNode.class);
            }

            public boolean isAutoExpandNode() {
                return true;
            }
        };
        this.myBuffer = new LinkedHashSet<StrutsFileSet>();
        this.originalConfiguration = strutsFacetConfiguration;
        this.module = facetEditorContext.getModule();
        this.myConfigsSearcher = new StrutsConfigsSearcher(this.module);
        SimpleTreeStructure structure = new SimpleTreeStructure(){

            public Object getRootElement() {
                return FileSetConfigurationTab.this.myRootNode;
            }
        };
        this.myTree = new SimpleTree();
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.getEmptyText().setText(StrutsBundle.message("facet.fileset.no.filesets.defined", new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        this.myBuilder = new SimpleTreeBuilder((JTree)this.myTree, (DefaultTreeModel)this.myTree.getModel(), (AbstractTreeStructure)structure, null);
        this.myBuilder.initRoot();
        final DumbService dumbService = DumbService.getInstance((Project)facetEditorContext.getProject());
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                StrutsFileSet fileSet = FileSetConfigurationTab.this.getCurrentFileSet();
                FileSetConfigurationTab.this.myEditButton.setEnabled(fileSet != null && !dumbService.isDumb());
                FileSetConfigurationTab.this.myRemoveButton.setEnabled(fileSet != null);
            }
        });
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        this.myTreePanel.add(ToolbarDecorator.createDecorator((JTree)this.myTree).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                StrutsFileSet fileSet = new StrutsFileSet(StrutsFileSet.getUniqueId(FileSetConfigurationTab.this.myBuffer), StrutsFileSet.getUniqueName(StrutsBundle.message("facet.fileset.my.fileset", new Object[0]), FileSetConfigurationTab.this.myBuffer), FileSetConfigurationTab.this.originalConfiguration){

                    @Override
                    public boolean isNew() {
                        return true;
                    }
                };
                FileSetEditor editor = new FileSetEditor(FileSetConfigurationTab.this.myPanel, fileSet, facetEditorContext, FileSetConfigurationTab.this.myConfigsSearcher);
                editor.show();
                if (editor.getExitCode() == 0) {
                    StrutsFileSet editedFileSet = editor.getEditedFileSet();
                    Disposer.register((Disposable)strutsFacetConfiguration, (Disposable)editedFileSet);
                    FileSetConfigurationTab.this.myBuffer.add(editedFileSet);
                    FileSetConfigurationTab.this.myModified = true;
                    FileSetConfigurationTab.this.myBuilder.updateFromRoot();
                    FileSetConfigurationTab.this.selectFileSet(fileSet);
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)FileSetConfigurationTab.this.myTree, true));
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FileSetConfigurationTab.this.remove();
                FileSetConfigurationTab.this.myModified = true;
                FileSetConfigurationTab.this.myBuilder.updateFromRoot();
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)FileSetConfigurationTab.this.myTree, true));
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                StrutsFileSet fileSet = FileSetConfigurationTab.this.getCurrentFileSet();
                if (fileSet != null) {
                    FileSetEditor editor = new FileSetEditor(FileSetConfigurationTab.this.myPanel, fileSet, facetEditorContext, FileSetConfigurationTab.this.myConfigsSearcher);
                    editor.show();
                    if (editor.getExitCode() == 0) {
                        FileSetConfigurationTab.this.myModified = true;
                        FileSetConfigurationTab.this.myBuffer.remove(fileSet);
                        StrutsFileSet edited = editor.getEditedFileSet();
                        Disposer.register((Disposable)strutsFacetConfiguration, (Disposable)edited);
                        FileSetConfigurationTab.this.myBuffer.add(edited);
                        edited.setAutodetected(false);
                        FileSetConfigurationTab.this.myBuilder.updateFromRoot();
                        FileSetConfigurationTab.this.selectFileSet(edited);
                    }
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)FileSetConfigurationTab.this.myTree, true));
                }
            }
        }).addExtraAction(AnActionButton.fromAction((AnAction)actionManager.createExpandAllAction(this.myTreeExpander, (JComponent)this.myTree))).addExtraAction(AnActionButton.fromAction((AnAction)actionManager.createCollapseAllAction(this.myTreeExpander, (JComponent)this.myTree))).addExtraAction(new AnActionButton("Open Struts 2 plugin documentation\u2026", AllIcons.Actions.Help){

            public void actionPerformed(AnActionEvent e) {
                BrowserUtil.browse((String)"https://confluence.jetbrains.com/pages/viewpage.action?pageId=35367");
            }
        }).disableUpDownActions().createPanel());
        this.myEditButton = ToolbarDecorator.findEditButton((JComponent)this.myTreePanel);
        this.myRemoveButton = ToolbarDecorator.findRemoveButton((JComponent)this.myTreePanel);
        AnActionButton addButton = ToolbarDecorator.findAddButton((JComponent)this.myTreePanel);
        assert (addButton != null);
        dumbService.makeDumbAware(addButton.getContextComponent(), (Disposable)this);
        dumbService.makeDumbAware(this.myEditButton.getContextComponent(), (Disposable)this);
    }

    @Nullable
    private StrutsFileSet getCurrentFileSet() {
        FileSetNode currentFileSetNode = this.getCurrentFileSetNode();
        return currentFileSetNode == null ? null : currentFileSetNode.mySet;
    }

    @Nullable
    private FileSetNode getCurrentFileSetNode() {
        SimpleNode selectedNode = this.myTree.getSelectedNode();
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode instanceof FileSetNode) {
            return (FileSetNode)selectedNode;
        }
        if (selectedNode.getParent() instanceof FileSetNode) {
            return (FileSetNode)selectedNode.getParent();
        }
        SimpleNode parent = selectedNode.getParent();
        if (parent != null && parent.getParent() instanceof FileSetNode) {
            return (FileSetNode)selectedNode.getParent().getParent();
        }
        return null;
    }

    private void selectFileSet(final StrutsFileSet fileSet) {
        this.myTree.select((AbstractTreeBuilder)this.myBuilder, new SimpleNodeVisitor(){

            public boolean accept(SimpleNode simpleNode) {
                return simpleNode instanceof FileSetNode && ((FileSetNode)simpleNode).mySet.equals(fileSet);
            }
        }, false);
    }

    private void remove() {
        SimpleNode[] nodes;
        for (SimpleNode node : nodes = this.myTree.getSelectedNodesIfUniform()) {
            if (node instanceof FileSetNode) {
                StrutsFileSet fileSet = ((FileSetNode)node).mySet;
                if (fileSet.getFiles().isEmpty()) {
                    this.myBuffer.remove(fileSet);
                    return;
                }
                int result = Messages.showYesNoDialog((Component)this.myPanel, (String)StrutsBundle.message("facet.fileset.remove.fileset.question", fileSet.getName()), (String)StrutsBundle.message("facet.fileset.remove.fileset.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result != 0) continue;
                if (fileSet.isAutodetected()) {
                    fileSet.setRemoved(true);
                    this.myBuffer.add(fileSet);
                    continue;
                }
                this.myBuffer.remove(fileSet);
                continue;
            }
            if (!(node instanceof ConfigFileNode)) continue;
            VirtualFilePointer filePointer = ((ConfigFileNode)node).myFilePointer;
            StrutsFileSet fileSet = ((FileSetNode)node.getParent()).mySet;
            fileSet.removeFile(filePointer);
        }
    }

    @Nls
    public String getDisplayName() {
        return StrutsBundle.message("facet.fileset.title", new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/facet/ui/FileSetConfigurationTab", "createComponent"));
        }
        return jPanel;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply() {
        Set<StrutsFileSet> fileSets = this.originalConfiguration.getFileSets();
        fileSets.clear();
        for (StrutsFileSet fileSet : this.myBuffer) {
            if (fileSet.isAutodetected() && !fileSet.isRemoved()) continue;
            fileSets.add(fileSet);
        }
        this.originalConfiguration.setModified();
        this.myModified = false;
    }

    public void reset() {
        this.myBuffer.clear();
        Set<StrutsFileSet> sets = StrutsManager.getInstance(this.module.getProject()).getAllConfigFileSets(this.module);
        for (StrutsFileSet fileSet : sets) {
            this.myBuffer.add(fileSet);
        }
        this.myBuilder.updateFromRoot();
        this.myTree.setSelectionRow(0);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myBuilder);
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    public String getHelpTopic() {
        return "reference.settings.project.structure.facets.struts2.facet";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTreePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static final class ConfigFileNode
    extends SimpleNode {
        private final VirtualFilePointer myFilePointer;

        ConfigFileNode(VirtualFilePointer name, SimpleNode parent) {
            super(parent);
            this.myFilePointer = name;
            this.setUniformIcon((Icon)StrutsIcons.STRUTS_CONFIG_FILE);
        }

        public boolean isAlwaysLeaf() {
            return true;
        }

        protected void doUpdate() {
            VirtualFile file = this.myFilePointer.getFile();
            if (file != null) {
                this.renderFile(file, this.getPlainAttributes(), null);
            } else {
                this.renderFile(file, this.getErrorAttributes(), StrutsBundle.message("facet.fileset.file.not.found", new Object[0]));
            }
        }

        private void renderFile(VirtualFile file, SimpleTextAttributes textAttributes, @Nullable String toolTip) {
            PresentationData presentation = this.getPresentation();
            presentation.setTooltip(toolTip);
            presentation.addText(this.myFilePointer.getFileName(), textAttributes);
            if (file != null) {
                presentation.setLocationString(file.getPath());
            }
        }

        public SimpleNode[] getChildren() {
            return NO_CHILDREN;
        }
    }

    private static class FileSetNode
    extends SimpleNode {
        protected final StrutsFileSet mySet;

        FileSetNode(StrutsFileSet fileSet) {
            this.mySet = fileSet;
            PresentationData presentationData = this.getPresentation();
            String name = this.mySet.getName();
            if (fileSet.getFiles().isEmpty()) {
                presentationData.addText(name, this.getErrorAttributes());
                presentationData.setTooltip(StrutsBundle.message("facet.fileset.no.files.attached", new Object[0]));
            } else {
                presentationData.addText(name, this.getPlainAttributes());
                presentationData.setLocationString(Integer.toString(fileSet.getFiles().size()));
            }
        }

        public SimpleNode[] getChildren() {
            ArrayList<ConfigFileNode> nodes = new ArrayList<ConfigFileNode>();
            for (VirtualFilePointer file : this.mySet.getFiles()) {
                nodes.add(new ConfigFileNode(file, this));
            }
            return (SimpleNode[])ArrayUtil.toObjectArray(nodes, SimpleNode.class);
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[]{this.mySet, this.mySet.getName(), this.mySet.getFiles()};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/facet/ui/FileSetConfigurationTab$FileSetNode", "getEqualityObjects"));
            }
            return objectArray;
        }
    }
}

