/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import com.jogamp.common.util.Bitstream;
import java.util.ArrayList;
import java.util.List;
import jogamp.common.os.elf.IOUtils;
import jogamp.common.os.elf.Section;
import jogamp.common.os.elf.SectionHeader;

public class SectionArmAttributes
extends Section {
    public static final byte FORMAT_VERSION_A = 65;
    public static final byte ABI_VFP_ARGS_IS_BASE_VARIANT = 0;
    public static final byte ABI_VFP_ARGS_IS_VFP_VARIANT = 1;
    public static final byte ABI_VFP_ARGS_IS_CUSTOM_VARIANT = 2;
    public static final byte ABI_VFP_ARGS_IS_BOTH_BASE_AND_VFP_VARIANT = 3;
    public final List<VendorAttributes> vendorAttributesList;

    public static final boolean abiVFPArgsAcceptsVFPVariant(byte by) {
        return 1 == by || 3 == by;
    }

    SectionArmAttributes(SectionHeader sectionHeader, byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        super(sectionHeader, byArray, n, n2);
        this.vendorAttributesList = SectionArmAttributes.parse(sectionHeader, byArray, n, n2);
    }

    @Override
    public String toString() {
        String string = super.toSubString();
        String string2 = String.valueOf(this.vendorAttributesList.toString());
        return new StringBuilder(24 + String.valueOf(string).length() + String.valueOf(string2).length()).append("SectionArmAttributes[").append(string).append(", ").append(string2).append("]").toString();
    }

    public final Attribute get(Tag tag) {
        for (int i = 0; i < this.vendorAttributesList.size(); ++i) {
            List<Attribute> list = this.vendorAttributesList.get((int)i).attributes;
            for (int j = 0; j < list.size(); ++j) {
                Attribute attribute = list.get(j);
                if (attribute.tag != tag) continue;
                return attribute;
            }
        }
        return null;
    }

    public final List<Attribute> get(String string) {
        return SectionArmAttributes.get(this.vendorAttributesList, string);
    }

    static final List<Attribute> get(List<VendorAttributes> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            VendorAttributes vendorAttributes = list.get(i);
            if (!vendorAttributes.vendor.equals(string)) continue;
            return vendorAttributes.attributes;
        }
        return null;
    }

    static List<VendorAttributes> parse(SectionHeader sectionHeader, byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        Bitstream.checkBounds(byArray, n, n2);
        Object object = n;
        if (65 != byArray[object]) {
            String string = String.valueOf(IOUtils.toHexString(byArray[object]));
            throw new IllegalArgumentException(string.length() != 0 ? "ShArmAttr: Not version A, but: ".concat(string) : new String("ShArmAttr: Not version A, but: "));
        }
        ++object;
        ArrayList<VendorAttributes> arrayList = new ArrayList<VendorAttributes>();
        boolean bl = sectionHeader.eh2.eh1.isBigEndian();
        while (object < n2) {
            Object object2;
            int n3 = object;
            int n4 = IOUtils.readUInt32(bl, byArray, object);
            Object object3 = new int[]{0};
            String string = IOUtils.getString(byArray, object += 4, n4 - 4, object3);
            object = object3[0];
            object3 = new ArrayList();
            while (object < n4) {
                object2 = new int[]{0};
                SectionArmAttributes.parseSub(bl, byArray, object, n4 - object, (int[])object2, (List<Attribute>)object3);
                object = object2[0];
            }
            if (n3 + n4 != object) {
                int n5 = n3 + n4;
                int n6 = object;
                throw new IllegalArgumentException(new StringBuilder(79).append("ShArmAttr: Section length count mismatch, expected ").append(n5).append(", has ").append(n6).toString());
            }
            object2 = SectionArmAttributes.get(arrayList, string);
            if (null != object2) {
                object2.addAll(object3);
                continue;
            }
            arrayList.add(new VendorAttributes(string, (List<Attribute>)object3));
        }
        return arrayList;
    }

    private static void parseSub(boolean bl, byte[] byArray, int n, int n2, int[] nArray, List<Attribute> list) throws IndexOutOfBoundsException, IllegalArgumentException {
        int n3;
        Bitstream.checkBounds(byArray, n, n2);
        Object object = n;
        byte by = byArray[object++];
        Tag tag = Tag.get(by);
        if (null == tag) {
            throw new IllegalArgumentException(new StringBuilder(53).append("ShArmAttr: Invalid Sub-Section tag (NaT): ").append(by).toString());
        }
        switch (tag) {
            case File: 
            case Section: 
            case Symbol: {
                n3 = IOUtils.readUInt32(bl, byArray, object);
                object += 4;
                break;
            }
            default: {
                String string = String.valueOf((Object)tag);
                throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(string).length()).append("ShArmAttr: Invalid Sub-Section tag: ").append(string).toString());
            }
        }
        if (Tag.File == tag) {
            block7: while (object < n + n3) {
                Object object2;
                byte by2;
                Tag tag2;
                if (null == (tag2 = Tag.get(by2 = byArray[object++]))) {
                    throw new IllegalArgumentException(new StringBuilder(51).append("ShArmAttr: Invalid Attribute tag (NaT): ").append(by2).toString());
                }
                switch (tag2.type) {
                    case NTBS: {
                        object2 = new int[]{0};
                        String string = IOUtils.getString(byArray, object, n3 + n - object, (int[])object2);
                        list.add(new Attribute(tag2, string));
                        object = object2[0];
                        continue block7;
                    }
                    case ULEB128: {
                        byte by3 = byArray[object++];
                        list.add(new Attribute(tag2, new Byte(by3)));
                        continue block7;
                    }
                }
                object2 = String.valueOf((Object)tag2);
                throw new IllegalArgumentException(new StringBuilder(34 + String.valueOf(object2).length()).append("ShArmAttr: Invalid Attribute tag: ").append((String)object2).toString());
            }
        }
        nArray[0] = n + n3;
    }

    public static class VendorAttributes {
        public final String vendor;
        public final List<Attribute> attributes;

        VendorAttributes(String string, List<Attribute> list) {
            this.vendor = string;
            this.attributes = list;
        }

        public String toString() {
            String string = String.valueOf(this.vendor);
            String string2 = String.valueOf(this.attributes.toString());
            return string2.length() != 0 ? string.concat(string2) : new String(string);
        }
    }

    public static class Attribute {
        public final Tag tag;
        private final Object value;

        Attribute(Tag tag, Object object) {
            this.tag = tag;
            this.value = object;
        }

        public final boolean isNTBS() {
            return Type.NTBS == this.tag.type;
        }

        public final String getNTBS() {
            if (Type.NTBS == this.tag.type) {
                return (String)this.value;
            }
            String string = String.valueOf((Object)this.tag.type);
            throw new IllegalArgumentException(new StringBuilder(13 + String.valueOf(string).length()).append("Not NTBS but ").append(string).toString());
        }

        public final boolean isULEB128() {
            return Type.ULEB128 == this.tag.type;
        }

        public final byte getULEB128() {
            if (Type.ULEB128 == this.tag.type) {
                return (Byte)this.value;
            }
            String string = String.valueOf((Object)this.tag.type);
            throw new IllegalArgumentException(new StringBuilder(16 + String.valueOf(string).length()).append("Not ULEB128 but ").append(string).toString());
        }

        public String toString() {
            String string = String.valueOf((Object)this.tag);
            String string2 = String.valueOf(this.value);
            return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" = ").append(string2).toString();
        }
    }

    public static enum Tag {
        None(0, Type.None),
        File(1, Type.SubSection),
        Section(2, Type.SubSection),
        Symbol(3, Type.SubSection),
        CPU_raw_name(4, Type.NTBS),
        CPU_name(5, Type.NTBS),
        CPU_arch(6, Type.ULEB128),
        CPU_arch_profile(7, Type.ULEB128),
        ARM_ISA_use(8, Type.ULEB128),
        THUMB_ISA_use(9, Type.ULEB128),
        FP_arch(10, Type.ULEB128),
        WMMX_arch(11, Type.ULEB128),
        Advanced_SIMD_arch(12, Type.ULEB128),
        PCS_config(13, Type.ULEB128),
        ABI_PCS_R9_use(14, Type.ULEB128),
        ABI_PCS_RW_data(15, Type.ULEB128),
        ABI_PCS_RO_data(16, Type.ULEB128),
        ABI_PCS_GOT_use(17, Type.ULEB128),
        ABI_PCS_wchar_t(18, Type.ULEB128),
        ABI_FP_rounding(19, Type.ULEB128),
        ABI_FP_denormal(20, Type.ULEB128),
        ABI_FP_exceptions(21, Type.ULEB128),
        ABI_FP_user_exceptions(22, Type.ULEB128),
        ABI_FP_number_model(23, Type.ULEB128),
        ABI_align_needed(24, Type.ULEB128),
        ABI_align_preserved(25, Type.ULEB128),
        ABI_enum_size(26, Type.ULEB128),
        ABI_HardFP_use(27, Type.ULEB128),
        ABI_VFP_args(28, Type.ULEB128),
        ABI_WMMX_args(29, Type.ULEB128),
        ABI_optimization_goals(30, Type.ULEB128),
        ABI_FP_optimization_goals(31, Type.ULEB128),
        compatibility(32, Type.NTBS),
        CPU_unaligned_access(34, Type.ULEB128),
        FP_HP_extension(36, Type.ULEB128),
        ABI_FP_16bit_format(38, Type.ULEB128),
        MPextension_use(42, Type.ULEB128),
        DIV_use(44, Type.ULEB128),
        nodefaults(64, Type.ULEB128),
        also_compatible_with(65, Type.ULEB128),
        T2EE_use(66, Type.ULEB128),
        conformance(67, Type.NTBS),
        Virtualization_use(68, Type.ULEB128),
        undefined69(69, Type.None),
        MPextension_use_legacy(70, Type.ULEB128);

        public final int id;
        public final Type type;

        public static Tag get(int n) {
            Tag[] tagArray = Tag.values();
            int n2 = tagArray.length;
            for (int i = 0; i < n2; ++i) {
                if (tagArray[i].id != n) continue;
                return tagArray[i];
            }
            return null;
        }

        private Tag(int n2, Type type) {
            this.id = n2;
            this.type = type;
        }
    }

    public static enum Type {
        None,
        SubSection,
        NTBS,
        ULEB128;

    }
}

