/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.javafx;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

enum JavaFXInstallator {
    INSTANCE;

    private static final NotNullLazyValue<String> URL;

    @NotNull
    private static String getJavaFXSdkURL() {
        String string;
        InputStream resource = JavaFXInstallator.class.getResourceAsStream("/org/intellij/plugins/markdown/javafx/location.properties");
        try {
            Properties properties = new Properties();
            properties.load(resource);
            string = properties.getProperty("javafx_sdk_overlay_location");
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not find location.properties. Check your installation.");
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/javafx/JavaFXInstallator", "getJavaFXSdkURL"));
        }
        return string;
    }

    public boolean installOpenJFXAndReport(@NotNull JComponent parentComponent) {
        DownloadableFileDescription fileDescription;
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "org/intellij/plugins/markdown/ui/preview/javafx/JavaFXInstallator", "installOpenJFXAndReport"));
        }
        DownloadableFileService fileService = DownloadableFileService.getInstance();
        FileDownloader downloader = fileService.createDownloader(Collections.singletonList(fileDescription = fileService.createFileDescription((String)URL.getValue(), "javafx-sdk-overlay.zip")), "OpenJFX");
        List progress = downloader.downloadWithProgress(this.getInstallationPath(), null, parentComponent);
        if (progress == null) {
            return false;
        }
        boolean success = false;
        for (Pair pair : progress) {
            if (!((DownloadableFileDescription)pair.getSecond()).equals(fileDescription)) {
                Logger.getInstance(JavaFXInstallator.class).warn("Another file downloaded: " + pair);
                continue;
            }
            VirtualFile file = (VirtualFile)pair.getFirst();
            if (file == null) continue;
            File archiveFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            try {
                ZipUtil.extract((File)archiveFile, (File)new File(this.getInstallationPath()), null, (boolean)true);
                Logger.getInstance(JavaFXInstallator.class).info("Downloaded and installed OpenJFX in " + archiveFile.getParent());
                success = true;
            }
            catch (IOException iOException) {}
        }
        return success;
    }

    public String getInstallationPath() {
        return PathManager.getConfigPath() + "/openjfx";
    }

    static {
        URL = new NotNullLazyValue<String>(){

            @NotNull
            protected String compute() {
                String string = JavaFXInstallator.getJavaFXSdkURL();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/javafx/JavaFXInstallator$1", "compute"));
                }
                return string;
            }
        };
    }
}

