/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.split;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.jetbrains.annotations.NotNull;

public class SplitEditorToolbar
extends JPanel
implements Disposable {
    private static final String LEFT_TOOLBAR_GROUP_ID = "Markdown.Toolbar.Left";
    private static final String RIGHT_TOOLBAR_GROUP_ID = "Markdown.Toolbar.Right";
    private final MySpacingPanel mySpacingPanel;
    private final ActionToolbar myRightToolbar;
    private final List<EditorGutterComponentEx> myGutters;
    private final ComponentAdapter myAdjustToGutterListener;

    public SplitEditorToolbar(@NotNull JComponent targetComponentForActions) {
        if (targetComponentForActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetComponentForActions", "org/intellij/plugins/markdown/ui/split/SplitEditorToolbar", "<init>"));
        }
        super(new GridBagLayout());
        this.myGutters = new ArrayList<EditorGutterComponentEx>();
        this.myAdjustToGutterListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SplitEditorToolbar.this.adjustSpacing();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                SplitEditorToolbar.this.adjustSpacing();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                SplitEditorToolbar.this.adjustSpacing();
            }
        };
        ActionToolbar leftToolbar = SplitEditorToolbar.createToolbarFromGroupId(LEFT_TOOLBAR_GROUP_ID);
        leftToolbar.setTargetComponent(targetComponentForActions);
        this.myRightToolbar = SplitEditorToolbar.createToolbarFromGroupId(RIGHT_TOOLBAR_GROUP_ID);
        this.myRightToolbar.setTargetComponent(targetComponentForActions);
        this.mySpacingPanel = new MySpacingPanel((int)leftToolbar.getComponent().getPreferredSize().getHeight());
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)new JLabel(MarkdownBundle.message("markdown.toolbar.view.label", new Object[0]), 4), "East");
        this.add(this.mySpacingPanel);
        this.add(leftToolbar.getComponent());
        this.add((Component)centerPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        this.add(this.myRightToolbar.getComponent());
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIUtil.CONTRAST_BORDER_COLOR));
        this.addComponentListener(this.myAdjustToGutterListener);
    }

    public void addGutterToTrack(@NotNull EditorGutterComponentEx gutterComponentEx) {
        if (gutterComponentEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gutterComponentEx", "org/intellij/plugins/markdown/ui/split/SplitEditorToolbar", "addGutterToTrack"));
        }
        this.myGutters.add(gutterComponentEx);
        gutterComponentEx.addComponentListener((ComponentListener)this.myAdjustToGutterListener);
    }

    public void refresh() {
        this.adjustSpacing();
        this.myRightToolbar.updateActionsImmediately();
    }

    private void adjustSpacing() {
        EditorGutterComponentEx leftMostGutter = null;
        for (EditorGutterComponentEx gutter : this.myGutters) {
            if (!gutter.isShowing() || leftMostGutter != null && leftMostGutter.getX() <= gutter.getX()) continue;
            leftMostGutter = gutter;
        }
        int spacing = leftMostGutter == null ? 0 : leftMostGutter.getWhitespaceSeparatorOffset();
        this.mySpacingPanel.setSpacing(spacing);
        this.revalidate();
        this.repaint();
    }

    public void dispose() {
        this.removeComponentListener(this.myAdjustToGutterListener);
        for (EditorGutterComponentEx gutter : this.myGutters) {
            gutter.removeComponentListener((ComponentListener)this.myAdjustToGutterListener);
        }
    }

    @NotNull
    private static ActionToolbar createToolbarFromGroupId(@NotNull String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/intellij/plugins/markdown/ui/split/SplitEditorToolbar", "createToolbarFromGroupId"));
        }
        ActionManager actionManager = ActionManager.getInstance();
        if (!actionManager.isGroup(groupId)) {
            throw new IllegalStateException(groupId + " should have been a group");
        }
        ActionGroup group = (ActionGroup)actionManager.getAction(groupId);
        ActionToolbarImpl editorToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("EditorToolbar", group, true);
        editorToolbar.setOpaque(false);
        editorToolbar.setBorder((Border)new JBEmptyBorder(0, 2, 0, 2));
        ActionToolbarImpl actionToolbarImpl = editorToolbar;
        if (actionToolbarImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/split/SplitEditorToolbar", "createToolbarFromGroupId"));
        }
        return actionToolbarImpl;
    }

    private static class MySpacingPanel
    extends JPanel {
        private final int myHeight;
        private int mySpacing;

        public MySpacingPanel(int height) {
            this.myHeight = height;
            this.mySpacing = 0;
            this.setOpaque(false);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.mySpacing, this.myHeight);
        }

        public void setSpacing(int spacing) {
            this.mySpacing = spacing;
        }
    }
}

