/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;
import jline.Terminal;

public class UnixTerminal
extends Terminal {
    public static final short ARROW_START = 27;
    public static final short ARROW_PREFIX = 91;
    public static final short ARROW_LEFT = 68;
    public static final short ARROW_RIGHT = 67;
    public static final short ARROW_UP = 65;
    public static final short ARROW_DOWN = 66;
    public static final short HOME_CODE = 72;
    public static final short END_CODE = 70;
    private Map terminfo;

    public void initializeTerminal() throws IOException, InterruptedException {
        final String string = UnixTerminal.stty("-g");
        if (string.length() == 0 || string.indexOf("=") == -1 && string.indexOf(":") == -1) {
            throw new IOException("Unrecognized stty code: " + string);
        }
        UnixTerminal.stty("-icanon min 1");
        UnixTerminal.stty("-echo");
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void start() {
                    try {
                        UnixTerminal.stty(string);
                    }
                    catch (Exception exception) {
                        UnixTerminal.this.consumeException(exception);
                    }
                }
            });
        }
        catch (AbstractMethodError abstractMethodError) {
            this.consumeException(abstractMethodError);
        }
    }

    public int readVirtualKey(InputStream inputStream) throws IOException {
        int n = this.readCharacter(inputStream);
        if (n == 27 && (n = this.readCharacter(inputStream)) == 91) {
            n = this.readCharacter(inputStream);
            if (n == 65) {
                return 16;
            }
            if (n == 66) {
                return 14;
            }
            if (n == 68) {
                return 2;
            }
            if (n == 67) {
                return 6;
            }
            if (n == 72) {
                return 1;
            }
            if (n == 70) {
                return 5;
            }
        }
        return n;
    }

    private void consumeException(Throwable throwable) {
    }

    public boolean isSupported() {
        return true;
    }

    public boolean getEcho() {
        return false;
    }

    public int getTerminalWidth() {
        int n = -1;
        try {
            n = UnixTerminal.getTerminalProperty("columns");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == -1) {
            n = 80;
        }
        return n;
    }

    public int getTerminalHeight() {
        int n = -1;
        try {
            n = UnixTerminal.getTerminalProperty("rows");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == -1) {
            n = 24;
        }
        return n;
    }

    private static int getTerminalProperty(String string) throws IOException, InterruptedException {
        String string2 = UnixTerminal.stty("-a");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.startsWith(string)) {
                int n = string3.lastIndexOf(" ");
                return Integer.parseInt(string3.substring(n).trim());
            }
            if (!string3.endsWith(string)) continue;
            int n = string3.indexOf(" ");
            return Integer.parseInt(string3.substring(0, n).trim());
        }
        return -1;
    }

    private static String stty(String string) throws IOException, InterruptedException {
        return UnixTerminal.exec("stty " + string + " < /dev/tty").trim();
    }

    private static String exec(String string) throws IOException, InterruptedException {
        return UnixTerminal.exec(new String[]{"sh", "-c", string});
    }

    private static String exec(String[] stringArray) throws IOException, InterruptedException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Process process = Runtime.getRuntime().exec(stringArray);
        InputStream inputStream = process.getInputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        inputStream = process.getErrorStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        process.waitFor();
        String string = new String(byteArrayOutputStream.toByteArray());
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println("width: " + new UnixTerminal().getTerminalWidth());
        System.out.println("height: " + new UnixTerminal().getTerminalHeight());
    }
}

