/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.SimpleEventRenderer;
import com.android.tools.adtui.model.EventAction;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.intellij.util.containers.ImmutableList;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleEventComponent<E extends Enum<E>>
extends AnimatedComponent {
    @NotNull
    private final RangedSeries<EventAction<EventAction.Action, E>> mData;
    @NotNull
    private final Map<E, SimpleEventRenderer> mRenderers;
    @NotNull
    private final ArrayList<EventRenderData> mIconsToDraw;

    public SimpleEventComponent(@NotNull RangedSeries<EventAction<EventAction.Action, E>> data, @NotNull Map<E, SimpleEventRenderer> renderers) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/adtui/SimpleEventComponent", "<init>"));
        }
        if (renderers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderers", "com/android/tools/adtui/SimpleEventComponent", "<init>"));
        }
        this.mData = data;
        this.mRenderers = renderers;
        this.mIconsToDraw = new ArrayList();
    }

    @Override
    protected void updateData() {
        double max = this.mData.getXRange().getMax();
        this.mIconsToDraw.clear();
        ImmutableList<SeriesData<EventAction<EventAction.Action, E>>> series = this.mData.getSeries();
        int size = series.size();
        for (int i = 0; i < size; ++i) {
            SeriesData seriesData = (SeriesData)series.get(i);
            EventAction data = (EventAction)seriesData.value;
            long endTimeUs = data.getEndUs() == 0L ? (long)max : data.getEndUs();
            this.mIconsToDraw.add(new EventRenderData(data.getValueData(), data.getStartUs(), endTimeUs));
        }
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double min = this.mData.getXRange().getMin();
        double max = this.mData.getXRange().getMax();
        double scaleFactor = dim.getWidth();
        for (int i = 0; i < this.mIconsToDraw.size(); ++i) {
            EventRenderData data = this.mIconsToDraw.get(i);
            double normalizedPositionStart = ((double)data.getStartTimestamp() - min) / (max - min);
            double normalizedPositionEnd = ((double)data.getEndTimestamp() - min) / (max - min);
            AffineTransform translate = AffineTransform.getTranslateInstance(normalizedPositionStart * scaleFactor, 0.0);
            this.mRenderers.get(data.getKey()).draw(this, g2d, translate, (normalizedPositionEnd - normalizedPositionStart) * scaleFactor);
        }
    }

    @Override
    protected void debugDraw(Graphics2D g) {
        super.debugDraw(g);
    }

    private static class EventRenderData<E> {
        private final E mKey;
        private final long mStartTimestamp;
        private final long mEndTimestamp;

        public E getKey() {
            return this.mKey;
        }

        public long getStartTimestamp() {
            return this.mStartTimestamp;
        }

        public long getEndTimestamp() {
            return this.mEndTimestamp;
        }

        public EventRenderData(E key, long startTimestamp, long endTimestamp) {
            this.mKey = key;
            this.mStartTimestamp = startTimestamp;
            this.mEndTimestamp = endTimestamp;
        }
    }
}

