/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.FloatingToolWindow;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatingToolWindowManager
implements ProjectComponent {
    private final Application myApplication;
    private final Project myProject;
    private final StartupManager myStartupManager;
    private final FileEditorManager myEditorManager;
    private final MyFileEditorManagerListener myEditorManagerListener;
    private final Map<FileEditor, WorkBench> myWorkBenchMap;
    private final HashMap<String, FloatingToolWindow> myToolWindowMap;
    private FloatingToolWindowFactory myFloatingToolWindowFactory;
    private MessageBusConnection myConnection;

    public static FloatingToolWindowManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/adtui/workbench/FloatingToolWindowManager", "getInstance"));
        }
        return (FloatingToolWindowManager)project.getComponent(FloatingToolWindowManager.class);
    }

    public FloatingToolWindowManager(@NotNull Application application, @NotNull Project currentProject, @NotNull StartupManager startupManager, @NotNull FileEditorManager fileEditorManager) {
        if (application == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "com/android/tools/adtui/workbench/FloatingToolWindowManager", "<init>"));
        }
        if (currentProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentProject", "com/android/tools/adtui/workbench/FloatingToolWindowManager", "<init>"));
        }
        if (startupManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startupManager", "com/android/tools/adtui/workbench/FloatingToolWindowManager", "<init>"));
        }
        if (fileEditorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorManager", "com/android/tools/adtui/workbench/FloatingToolWindowManager", "<init>"));
        }
        this.myApplication = application;
        this.myProject = currentProject;
        this.myStartupManager = startupManager;
        this.myEditorManager = fileEditorManager;
        this.myEditorManagerListener = new MyFileEditorManagerListener();
        this.myWorkBenchMap = new IdentityHashMap<FileEditor, WorkBench>(13);
        this.myToolWindowMap = new HashMap(8);
        this.myFloatingToolWindowFactory = FloatingToolWindow::new;
    }

    void setFloatingToolWindowFactory(@NotNull FloatingToolWindowFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/android/tools/adtui/workbench/FloatingToolWindowManager", "setFloatingToolWindowFactory"));
        }
        this.myFloatingToolWindowFactory = factory;
    }

    public void register(@Nullable FileEditor fileEditor, @NotNull WorkBench workBench) {
        if (workBench == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workBench", "com/android/tools/adtui/workbench/FloatingToolWindowManager", "register"));
        }
        if (fileEditor != null) {
            this.myWorkBenchMap.put(fileEditor, workBench);
        }
    }

    public void unregister(@Nullable FileEditor fileEditor) {
        if (fileEditor != null) {
            this.myWorkBenchMap.remove(fileEditor);
        }
    }

    @NotNull
    public String getComponentName() {
        String string = FloatingToolWindowManager.class.getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/workbench/FloatingToolWindowManager", "getComponentName"));
        }
        return string;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
        this.myStartupManager.runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
            this.myConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
            this.myConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myEditorManagerListener);
            this.updateToolWindowsForWorkBench(this.getActiveWorkBench());
        }));
    }

    public void projectClosed() {
        if (this.myConnection != null) {
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    @Nullable
    private WorkBench getActiveWorkBench() {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof WorkBench) {
            return (WorkBench)((Object)focusOwner);
        }
        WorkBench current = (WorkBench)((Object)SwingUtilities.getAncestorOfClass(WorkBench.class, focusOwner));
        if (current != null) {
            return current;
        }
        FileEditor[] selectedEditors = this.myEditorManager.getSelectedEditors();
        if (selectedEditors.length == 0) {
            return null;
        }
        if (selectedEditors.length == 1) {
            return this.myWorkBenchMap.get(selectedEditors[0]);
        }
        if (focusOwner != null) {
            for (FileEditor editor : selectedEditors) {
                if (!SwingUtilities.isDescendingFrom(focusOwner, editor.getComponent())) continue;
                return this.myWorkBenchMap.get(editor);
            }
        }
        return this.myWorkBenchMap.get(selectedEditors[0]);
    }

    public <T> void updateToolWindowsForWorkBench(@Nullable WorkBench<T> workBench) {
        HashSet<String> ids = new HashSet<String>(this.myToolWindowMap.keySet());
        if (workBench != null) {
            List<AttachedToolWindow<T>> floatingToolWindows = workBench.getFloatingToolWindows();
            for (AttachedToolWindow<T> tool : floatingToolWindows) {
                ToolWindowDefinition<T> definition = tool.getDefinition();
                String id2 = definition.getName();
                FloatingToolWindow floatingToolWindow = this.myToolWindowMap.get(id2);
                if (floatingToolWindow == null) {
                    floatingToolWindow = this.myFloatingToolWindowFactory.create(this.myProject, definition);
                    Disposer.register((Disposable)this.myProject, (Disposable)floatingToolWindow);
                    this.myToolWindowMap.put(id2, floatingToolWindow);
                }
                floatingToolWindow.show(tool);
                ids.remove(id2);
            }
        }
        ids.forEach(id -> this.myToolWindowMap.get(id).hide());
    }

    public void restoreDefaultLayout() {
        this.myApplication.invokeLater(() -> this.updateToolWindowsForWorkBench(this.getActiveWorkBench()));
    }

    static interface FloatingToolWindowFactory {
        public FloatingToolWindow create(@NotNull Project var1, @NotNull ToolWindowDefinition var2);
    }

    private class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/adtui/workbench/FloatingToolWindowManager$MyFileEditorManagerListener", "fileOpened"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/adtui/workbench/FloatingToolWindowManager$MyFileEditorManagerListener", "fileOpened"));
            }
            FloatingToolWindowManager.this.updateToolWindowsForWorkBench(FloatingToolWindowManager.this.getActiveWorkBench());
        }

        public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/adtui/workbench/FloatingToolWindowManager$MyFileEditorManagerListener", "fileClosed"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/adtui/workbench/FloatingToolWindowManager$MyFileEditorManagerListener", "fileClosed"));
            }
            FloatingToolWindowManager.this.myApplication.invokeLater(() -> FloatingToolWindowManager.this.updateToolWindowsForWorkBench(FloatingToolWindowManager.this.getActiveWorkBench()));
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/workbench/FloatingToolWindowManager$MyFileEditorManagerListener", "selectionChanged"));
            }
            FloatingToolWindowManager.this.updateToolWindowsForWorkBench((WorkBench)((Object)FloatingToolWindowManager.this.myWorkBenchMap.get(event.getNewEditor())));
        }
    }
}

