/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.steps.search.CucumberStepSearchUtil;

public class CucumberUtil {
    @NonNls
    public static final String STEP_DEFINITIONS_DIR_NAME = "step_definitions";
    public static final String[][] ARR = new String[][]{{"\\\\", "\\\\\\\\"}, {"\\|", "\\\\|"}, {"\\$", "\\\\\\$"}, {"\\^", "\\\\^"}, {"\\+", "\\+"}, {"\\-", "\\\\-"}, {"\\#", "\\\\#"}, {"\\?", "\\\\?"}, {"\\*", "\\\\*"}, {"\\/", "\\\\/"}, {"\\{", "\\\\{"}, {"\\}", "\\\\}"}, {"\\[", "\\\\["}, {"\\]", "\\\\]"}, {"\\(", "\\\\("}, {"\\)", "\\\\)"}, {"\\+", "\\\\+"}, {"\"([^\\\\\"]*)\"", "\"([^\"]*)\""}, {"(?<=^|[ .,])\\d+[ ]", "(\\\\d+) "}, {"(?<=^|[ .,])\\d+[,]", "(\\\\d+),"}, {"(?<=^|[ .,])\\d+[.]", "(\\\\d+)."}, {"(?<=^|[ .,])\\d+$", "(\\\\d+)"}, {"\\.", "\\\\."}, {"(<[^>]*>)", "(.*)"}};
    public static final char LEFT_PAR = '(';
    public static final char RIGHT_PAR = ')';
    public static final char LEFT_SQUARE_BRACE = '[';
    public static final char RIGHT_SQUARE_BRACE = ']';
    public static final char LEFT_BRACE = '{';
    public static final char RIGHT_BRACE = '}';
    public static final char ESCAPE_SLASH = '\\';
    public static final String PREFIX_CHAR = "^";
    public static final String SUFFIX_CHAR = "$";

    public static boolean findGherkinReferencesToElement(@NotNull PsiElement stepDefinitionElement, @NotNull String regexp, @NotNull Processor<PsiReference> consumer, @NotNull SearchScope effectiveSearchScope) {
        if (stepDefinitionElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stepDefinitionElement", "org/jetbrains/plugins/cucumber/CucumberUtil", "findGherkinReferencesToElement"));
        }
        if (regexp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexp", "org/jetbrains/plugins/cucumber/CucumberUtil", "findGherkinReferencesToElement"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/cucumber/CucumberUtil", "findGherkinReferencesToElement"));
        }
        if (effectiveSearchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectiveSearchScope", "org/jetbrains/plugins/cucumber/CucumberUtil", "findGherkinReferencesToElement"));
        }
        return CucumberUtil.findPossibleGherkinElementUsages(stepDefinitionElement, regexp, new MyReferenceCheckingProcessor(stepDefinitionElement, consumer), effectiveSearchScope);
    }

    public static boolean findPossibleGherkinElementUsages(@NotNull PsiElement stepDefinitionElement, @NotNull String regexp, @NotNull TextOccurenceProcessor processor, @NotNull SearchScope effectiveSearchScope) {
        if (stepDefinitionElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stepDefinitionElement", "org/jetbrains/plugins/cucumber/CucumberUtil", "findPossibleGherkinElementUsages"));
        }
        if (regexp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexp", "org/jetbrains/plugins/cucumber/CucumberUtil", "findPossibleGherkinElementUsages"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/cucumber/CucumberUtil", "findPossibleGherkinElementUsages"));
        }
        if (effectiveSearchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectiveSearchScope", "org/jetbrains/plugins/cucumber/CucumberUtil", "findPossibleGherkinElementUsages"));
        }
        String word = CucumberUtil.getTheBiggestWordToSearchByIndex(regexp);
        if (StringUtil.isEmptyOrSpaces((String)word)) {
            return true;
        }
        SearchScope searchScope = CucumberStepSearchUtil.restrictScopeToGherkinFiles((Computable<SearchScope>)((Computable)() -> {
            if (effectiveSearchScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "effectiveSearchScope", "org/jetbrains/plugins/cucumber/CucumberUtil", "lambda$findPossibleGherkinElementUsages$0"));
            }
            return effectiveSearchScope;
        }));
        int context = 5;
        PsiSearchHelper instance = PsiSearchHelper.SERVICE.getInstance((Project)stepDefinitionElement.getProject());
        return instance.processElementsWithWord(processor, searchScope, word, (short)5, true);
    }

    public static String getTheBiggestWordToSearchByIndex(@NotNull String regexp) {
        if (regexp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexp", "org/jetbrains/plugins/cucumber/CucumberUtil", "getTheBiggestWordToSearchByIndex"));
        }
        String result = "";
        if (regexp.startsWith(PREFIX_CHAR)) {
            regexp = regexp.substring(1);
        }
        if (regexp.endsWith(SUFFIX_CHAR)) {
            regexp = regexp.substring(0, regexp.length() - 1);
        }
        int par = 0;
        int squareBrace = 0;
        int brace = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < regexp.length(); ++i) {
            char c = regexp.charAt(i);
            if (c == '#') {
                sb = new StringBuilder();
                continue;
            }
            if (c != '\\') {
                if (c == '(') {
                    ++par;
                }
                if (c == ')' && par > 0) {
                    --par;
                }
                if (c == '{') {
                    ++brace;
                }
                if (c == '}' && brace > 0) {
                    --brace;
                }
                if (c == '[') {
                    ++squareBrace;
                }
                if (c == ']' && squareBrace > 0) {
                    --squareBrace;
                }
            } else {
                sb = new StringBuilder();
                ++i;
            }
            if (par > 0 | squareBrace > 0 | brace > 0) {
                if (par + squareBrace + brace != 1) continue;
                sb = new StringBuilder();
                continue;
            }
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
                if (sb.length() <= 0 || sb.toString().length() <= result.length()) continue;
                result = sb.toString();
                continue;
            }
            sb = new StringBuilder();
        }
        if (sb.length() > 0 && sb.toString().length() > result.length()) {
            result = sb.toString();
        }
        return result;
    }

    public static String prepareStepRegexp(String stepName) {
        String result = stepName;
        for (String[] rule : ARR) {
            result = result.replaceAll(rule[0], rule[1]);
        }
        return result;
    }

    private static class MyReferenceCheckingProcessor
    implements TextOccurenceProcessor {
        @NotNull
        private final PsiElement myElementToFind;
        @NotNull
        private final Processor<PsiReference> myConsumer;

        private MyReferenceCheckingProcessor(@NotNull PsiElement elementToFind, @NotNull Processor<PsiReference> consumer) {
            if (elementToFind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToFind", "org/jetbrains/plugins/cucumber/CucumberUtil$MyReferenceCheckingProcessor", "<init>"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/cucumber/CucumberUtil$MyReferenceCheckingProcessor", "<init>"));
            }
            this.myElementToFind = elementToFind;
            this.myConsumer = consumer;
        }

        public boolean execute(@NotNull PsiElement element, int offsetInElement) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/CucumberUtil$MyReferenceCheckingProcessor", "execute"));
            }
            PsiElement parent = element.getParent();
            boolean result = this.executeInternal(element);
            if (result && parent != null) {
                return this.executeInternal(parent);
            }
            return result;
        }

        private boolean executeInternal(@NotNull PsiElement referenceOwner) {
            if (referenceOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceOwner", "org/jetbrains/plugins/cucumber/CucumberUtil$MyReferenceCheckingProcessor", "executeInternal"));
            }
            for (PsiReference ref : referenceOwner.getReferences()) {
                if (ref == null || !ref.isReferenceTo(this.myElementToFind) || this.myConsumer.process((Object)ref)) continue;
                return false;
            }
            return true;
        }
    }
}

