/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.CucumberAddExamplesColonFix;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinExamplesBlockImpl;

public class CucumberExamplesColonInspection
extends GherkinInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CucumberBundle.message("inspection.missed.colon.example.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberExamplesColonInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("CucumberExamplesColon" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberExamplesColonInspection", "getShortName"));
        }
        return "CucumberExamplesColon";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberExamplesColonInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/cucumber/inspections/CucumberExamplesColonInspection", "buildVisitor"));
        }
        GherkinElementVisitor gherkinElementVisitor = new GherkinElementVisitor(){

            @Override
            public void visitExamplesBlock(GherkinExamplesBlockImpl block) {
                String text;
                PsiElement examples = block.getFirstChild();
                assert (examples != null);
                PsiElement next = examples.getNextSibling();
                String string = text = next != null ? next.getText() : null;
                if (text == null || !text.contains(":")) {
                    holder.registerProblem(examples, new TextRange(0, examples.getTextRange().getEndOffset() - examples.getTextOffset()), CucumberBundle.message("inspection.missed.colon.example.name", new Object[0]), new LocalQuickFix[]{new CucumberAddExamplesColonFix()});
                }
            }
        };
        if (gherkinElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/inspections/CucumberExamplesColonInspection", "buildVisitor"));
        }
        return gherkinElementVisitor;
    }
}

