/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.toolWindow.tree.nodes;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.jsf.toolWindow.tree.nodes.FacesModelNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModelElementNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModelNodeUtils;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModuleNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfNodeTypes;
import com.intellij.jsf.toolWindow.tree.nodes.WebFacetNode;
import com.intellij.jsf.utils.FacesConfigUtils;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJsfTypeNode
extends SimpleNode {
    private Module myModule;
    private JsfNodeTypes myType;
    private boolean myShowFromLibraries;

    protected AbstractJsfTypeNode(JsfModuleNode jsfModuleNode, @NotNull Module module, @NotNull JsfNodeTypes type, boolean showFromLibraries) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode", "<init>"));
        }
        super((SimpleNode)jsfModuleNode);
        this.myModule = module;
        this.myType = type;
        this.myShowFromLibraries = showFromLibraries;
    }

    public Module getModule() {
        return this.myModule;
    }

    public JsfNodeTypes getType() {
        return this.myType;
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myType, this.myShowFromLibraries};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode", "getEqualityObjects"));
        }
        return objectArray;
    }

    public final SimpleNode[] getChildren() {
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        Collection<JsfModelElementNode> annotatedNodes = JsfModelNodeUtils.createSortedList();
        this.addFacesConfigsNodes(nodes);
        this.addAnnotatedNodes(annotatedNodes);
        nodes.addAll(annotatedNodes);
        return nodes.toArray(new SimpleNode[nodes.size()]);
    }

    private void addFacesConfigsNodes(List<SimpleNode> nodes) {
        Collection webFacets = WebFacet.getInstances((Module)this.getModule());
        if (webFacets.size() == 1) {
            nodes.addAll(this.getWebFacetsNodes((WebFacet)webFacets.iterator().next()));
        } else {
            for (WebFacet webFacet : webFacets) {
                final Collection<SimpleNode> webFacetNodes = this.getWebFacetsNodes(webFacet);
                if (webFacetNodes.size() <= 0) continue;
                nodes.add(new WebFacetNode(webFacet, this){

                    @Override
                    public SimpleNode[] getChildren() {
                        return webFacetNodes.toArray(new SimpleNode[webFacetNodes.size()]);
                    }
                });
            }
        }
    }

    @NotNull
    private Collection<SimpleNode> getWebFacetsNodes(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode", "getWebFacetsNodes"));
        }
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        List<FacesDomModel> models = this.getFacesDomModels(webFacet);
        if (models.size() == 1) {
            nodes.addAll(this.getFacesDomModelNodes(models.get(0)));
        } else {
            for (FacesDomModel model : models) {
                final Collection<SimpleNode> modelNodes = this.getFacesDomModelNodes(model);
                if (modelNodes.size() <= 0) continue;
                nodes.add(new FacesModelNode(webFacet.getModule().getProject(), model, this){

                    @Override
                    public SimpleNode[] getChildren() {
                        return modelNodes.toArray(new SimpleNode[modelNodes.size()]);
                    }
                });
            }
        }
        ArrayList<SimpleNode> arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode", "getWebFacetsNodes"));
        }
        return arrayList;
    }

    @NotNull
    private List<FacesDomModel> getFacesDomModels(WebFacet webFacet) {
        if (this.isShowFromLibraries()) {
            List<FacesDomModel> list = FacesDomModelManager.getInstance(this.getModule().getProject()).getAllModels(webFacet);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode", "getFacesDomModels"));
            }
            return list;
        }
        ArrayList<FacesDomModel> models = new ArrayList<FacesDomModel>();
        AbstractJsfTypeNode.addNotNullModel(webFacet, models, FacesConfigUtils.getFacesConfigsFromWebInf(webFacet));
        for (XmlFile xmlFile : FacesConfigUtils.getFacesConfigDefinedInWebXml(webFacet)) {
            AbstractJsfTypeNode.addNotNullModel(webFacet, models, xmlFile);
        }
        ArrayList<FacesDomModel> arrayList = models;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode", "getFacesDomModels"));
        }
        return arrayList;
    }

    private static void addNotNullModel(@NotNull WebFacet webFacet, @NotNull List<FacesDomModel> models, @Nullable XmlFile xmlFile) {
        FacesDomModel domModel;
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode", "addNotNullModel"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/jsf/toolWindow/tree/nodes/AbstractJsfTypeNode", "addNotNullModel"));
        }
        if (xmlFile != null && (domModel = FacesDomModelManager.getInstance(webFacet.getModule().getProject()).getFacesDomModel(xmlFile, webFacet)) != null) {
            models.add(domModel);
        }
    }

    protected abstract void addAnnotatedNodes(Collection<JsfModelElementNode> var1);

    @NotNull
    protected abstract Collection<SimpleNode> getFacesDomModelNodes(@NotNull FacesDomModel var1);

    public boolean isShowFromLibraries() {
        return this.myShowFromLibraries;
    }
}

