/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.androidPlugin;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class AndroidPluginOutputParser
implements PatternAwareOutputParser {
    private static final int SEGMENT_COUNT = 3;
    private static final Pattern IGNORED_MESSAGE_PATTERN = Pattern.compile("[\\d]+[\\s]+[\\w]+:[\\w]+=[\"|'].*[\"|']");

    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Message> messages, @NotNull ILogger logger) throws ParsingFailedException {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/gradle/output/parser/androidPlugin/AndroidPluginOutputParser", "parse"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/android/tools/idea/gradle/output/parser/androidPlugin/AndroidPluginOutputParser", "parse"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/android/tools/idea/gradle/output/parser/androidPlugin/AndroidPluginOutputParser", "parse"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/android/tools/idea/gradle/output/parser/androidPlugin/AndroidPluginOutputParser", "parse"));
        }
        if (line.contains("[DEBUG] ") || line.contains("[INFO] ")) {
            return false;
        }
        if (IGNORED_MESSAGE_PATTERN.matcher(line).matches()) {
            return false;
        }
        String[] segments = line.split("\\|", 3);
        if (segments.length == 3) {
            Message.Kind kind = Message.Kind.findIgnoringCase(segments[0], Message.Kind.ERROR);
            String path = segments[1];
            if (StringUtil.isEmpty((String)path)) {
                return false;
            }
            String msg = StringUtil.notNullize((String)segments[2]);
            messages.add(new Message(kind, msg.trim(), new SourceFilePosition(new SourceFile(path.trim()), SourcePosition.UNKNOWN), new SourceFilePosition[0]));
            return true;
        }
        return false;
    }
}

