/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.editor;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"DECORATED", "Lcom/intellij/openapi/util/Key;", "Ljavax/swing/JComponent;", "kotlin.jvm.PlatformType", "DECORATED_ARTEFACT_TYPES", "", "Lorg/jetbrains/plugins/grails/util/GrailsArtifact;", "getDECORATED_ARTEFACT_TYPES", "()[Lorg/jetbrains/plugins/grails/util/GrailsArtifact;", "[Lorg/jetbrains/plugins/grails/util/GrailsArtifact;", "shouldBeDecorated", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "groovy-mvc"})
public final class GrailsEditorDecoratorKt {
    @NotNull
    private static final GrailsArtifact[] DECORATED_ARTEFACT_TYPES;
    private static final Key<JComponent> DECORATED;

    @NotNull
    public static final GrailsArtifact[] getDECORATED_ARTEFACT_TYPES() {
        return DECORATED_ARTEFACT_TYPES;
    }

    private static final boolean shouldBeDecorated(Project project, VirtualFile file) {
        String controllerName;
        FileType fileType = file.getFileType();
        if (fileType == GroovyFileType.GROOVY_FILE_TYPE) {
            if (Intrinsics.areEqual((Object)file.getExtension(), (Object)"gson") || GrailsUtils.isInGrailsTests(file, project)) {
                return true;
            }
            GrTypeDefinition classDefinition = GroovyUtils.getPublicClass((Project)project, (VirtualFile)file);
            GrailsArtifact artifact = GrailsArtifact.getType((PsiClass)classDefinition);
            if (ArraysKt.contains((Object[])((Object[])DECORATED_ARTEFACT_TYPES), (Object)((Object)artifact))) {
                return true;
            }
        } else if ((fileType == GspFileType.GSP_FILE_TYPE || Intrinsics.areEqual((Object)"jsp", (Object)file.getExtension())) && (controllerName = GrailsUtils.getControllerNameByGsp(file)) != null && Intrinsics.areEqual((Object)controllerName, (Object)"layouts") ^ true && StringUtil.isJavaIdentifier((String)controllerName)) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        Object[] elements$iv = (Object[])new GrailsArtifact[]{GrailsArtifact.DOMAIN, GrailsArtifact.CONTROLLER, GrailsArtifact.SERVICE};
        DECORATED_ARTEFACT_TYPES = (GrailsArtifact[])var0;
        DECORATED = Key.create((String)"grails.decorator.decorated");
    }

    @NotNull
    public static final /* synthetic */ Key access$getDECORATED$p() {
        return DECORATED;
    }

    public static final /* synthetic */ boolean access$shouldBeDecorated(@NotNull Project project, @NotNull VirtualFile file) {
        return GrailsEditorDecoratorKt.shouldBeDecorated(project, file);
    }
}

