/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.feature.forge;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.NullableConsumer;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleParentProjectForm;
import org.jetbrains.plugins.grails.feature.forge.CoverPane;
import org.jetbrains.plugins.grails.feature.forge.DomainKt;
import org.jetbrains.plugins.grails.feature.forge.FFeature;
import org.jetbrains.plugins.grails.feature.forge.FProfile;
import org.jetbrains.plugins.grails.feature.forge.FVersion;
import org.jetbrains.plugins.grails.feature.forge.GrailsForgeBundle;

public class GrailsForgeOptionsForm
implements Disposable {
    private static final String FEATURE_KEY = "grails.application.forge.feature";
    private JPanel myMainPanel;
    private ComboBox<String> myProjectType;
    private ComboBox<FVersion> myVersions;
    private ComboBox<FProfile> myProfiles;
    private JPanel myFeaturesPanel;
    private JPanel myParentGradleProjectPane;
    @NotNull
    private final GradleParentProjectForm myGradleParentProjectForm;
    private final CoverPane myCoverPane;
    private final JBLoadingPanel myPanel;
    private boolean myLoadingFinished = false;

    public GrailsForgeOptionsForm(WizardContext context) {
        NullableConsumer nullableConsumer = p -> this.updateComponents();
        this.$$$setupUI$$$();
        this.myGradleParentProjectForm = new GradleParentProjectForm(context, nullableConsumer);
        this.myParentGradleProjectPane.add(this.myGradleParentProjectForm.getComponent());
        this.myVersions.addItemListener(e -> this.versionChanged());
        this.myProfiles.addItemListener(e -> this.profileChanged());
        this.myCoverPane = new CoverPane(this.myMainPanel);
        this.myCoverPane.hideContent();
        this.myPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        this.myPanel.add((Component)this.myCoverPane);
        this.myPanel.addListener((JBLoadingPanelListener)new JBLoadingPanelListener.Adapter(){

            public void onLoadingFinish() {
                GrailsForgeOptionsForm.this.myCoverPane.showContent();
            }
        });
    }

    private void setVersions(@NotNull List<FVersion> versions) {
        if (versions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "org/jetbrains/plugins/grails/feature/forge/GrailsForgeOptionsForm", "setVersions"));
        }
        this.myVersions.setModel((ComboBoxModel)new CollectionComboBoxModel(versions));
        FVersion latestVersion = DomainKt.findLatestNonSnapshotVersion(versions);
        if (latestVersion != null) {
            this.myVersions.setSelectedItem((Object)latestVersion);
        } else {
            this.versionChanged();
        }
        this.myLoadingFinished = true;
    }

    private void versionChanged() {
        this.setProfiles(this.getSelectedVersion().getProfiles());
    }

    private void setProfiles(@NotNull List<FProfile> profiles) {
        if (profiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profiles", "org/jetbrains/plugins/grails/feature/forge/GrailsForgeOptionsForm", "setProfiles"));
        }
        this.myProfiles.setModel((ComboBoxModel)new CollectionComboBoxModel(profiles));
        FProfile webProfile = DomainKt.findWebProfile(profiles);
        if (webProfile != null) {
            this.myProfiles.setSelectedItem((Object)webProfile);
        } else {
            this.profileChanged();
        }
    }

    private void profileChanged() {
        FProfile profile = this.getSelectedProfile();
        this.myProfiles.setToolTipText(profile.getDescription());
        this.myFeaturesPanel.removeAll();
        List<FFeature> features = profile.getFeatures();
        if (features.isEmpty()) {
            return;
        }
        this.myFeaturesPanel.setLayout((LayoutManager)new GridLayoutManager(features.size(), 2));
        GridConstraints labelConstraints = new GridConstraints();
        labelConstraints.setUseParentLayout(true);
        labelConstraints.setFill(1);
        JBLabel label = new JBLabel("", 2);
        label.setLabelFor((Component)this.myFeaturesPanel);
        LabeledComponent.TextWithMnemonic mnemonic = LabeledComponent.TextWithMnemonic.fromTextWithMnemonic((String)GrailsForgeBundle.message("label.features", new Object[0]));
        mnemonic.setToLabel((JLabel)label);
        this.myFeaturesPanel.add((Component)label, labelConstraints);
        GridConstraints constraints = new GridConstraints();
        constraints.setColumn(1);
        constraints.setUseParentLayout(true);
        constraints.setFill(1);
        for (FFeature feature : features) {
            JBCheckBox checkBox = new JBCheckBox();
            checkBox.setText(feature.getName());
            checkBox.setToolTipText(feature.getDescription());
            checkBox.setSelected(feature.getDefault() || feature.getRequired());
            checkBox.setEnabled(!feature.getRequired());
            checkBox.putClientProperty((Object)FEATURE_KEY, (Object)feature);
            this.myFeaturesPanel.add((Component)checkBox, constraints);
            constraints.setRow(constraints.getRow() + 1);
        }
        this.myFeaturesPanel.revalidate();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myGradleParentProjectForm);
    }

    @NotNull
    public JComponent getComponent() {
        JBLoadingPanel jBLoadingPanel = this.myPanel;
        if (jBLoadingPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/feature/forge/GrailsForgeOptionsForm", "getComponent"));
        }
        return jBLoadingPanel;
    }

    public boolean validate() {
        return this.myLoadingFinished;
    }

    @Nullable
    public ProjectData getParentProject() {
        return this.myGradleParentProjectForm.getParentProject();
    }

    @NotNull
    public String getSelectedProjectType() {
        String string = Objects.requireNonNull(StringUtil.toLowerCase((String)((String)this.myProjectType.getSelectedItem())));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/feature/forge/GrailsForgeOptionsForm", "getSelectedProjectType"));
        }
        return string;
    }

    @NotNull
    public FVersion getSelectedVersion() {
        FVersion fVersion = (FVersion)Objects.requireNonNull(this.myVersions.getSelectedItem());
        if (fVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/feature/forge/GrailsForgeOptionsForm", "getSelectedVersion"));
        }
        return fVersion;
    }

    @NotNull
    public FProfile getSelectedProfile() {
        FProfile fProfile = (FProfile)Objects.requireNonNull(this.myProfiles.getSelectedItem());
        if (fProfile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/feature/forge/GrailsForgeOptionsForm", "getSelectedProfile"));
        }
        return fProfile;
    }

    @NotNull
    public List<String> getSelectedFeatures() {
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Component component : this.myFeaturesPanel.getComponents()) {
            FFeature feature;
            JBCheckBox checkBox;
            if (!(component instanceof JBCheckBox) || !(checkBox = (JBCheckBox)component).isSelected() || (feature = (FFeature)checkBox.getClientProperty((Object)FEATURE_KEY)) == null) continue;
            result2.add(feature.getName());
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/feature/forge/GrailsForgeOptionsForm", "getSelectedFeatures"));
        }
        return arrayList;
    }

    public void init(@NotNull Producer<List<FVersion>> producer) {
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "org/jetbrains/plugins/grails/feature/forge/GrailsForgeOptionsForm", "init"));
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (producer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "org/jetbrains/plugins/grails/feature/forge/GrailsForgeOptionsForm", "lambda$init$5"));
            }
            SwingUtilities.invokeLater(() -> this.myPanel.startLoading());
            List versions = (List)producer.produce();
            if (versions == null) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                this.setVersions(versions);
                this.myPanel.stopLoading();
                this.myPanel.revalidate();
            });
        });
        this.updateComponents();
    }

    public void updateComponents() {
        this.myGradleParentProjectForm.updateComponents();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        ComboBox comboBox;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 5, 0, 6), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Project Type:");
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProjectType = comboBox3 = new ComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Application");
        defaultComboBoxModel.addElement("Plugin");
        comboBox3.setModel(defaultComboBoxModel);
        jPanel3.add((Component)comboBox3, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("org/jetbrains/plugins/grails/feature/forge/GrailsForgeBundle").getString("label.version"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersions = comboBox2 = new ComboBox();
        jPanel3.add((Component)comboBox2, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("org/jetbrains/plugins/grails/feature/forge/GrailsForgeBundle").getString("label.profile"));
        jPanel3.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProfiles = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(3, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myFeaturesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 2, 3, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(5, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.myParentGradleProjectPane = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)comboBox3);
        jBLabel2.setLabelFor((Component)comboBox2);
        jBLabel3.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

