/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class PluginSupportFileReferenceSet
extends FileReferenceSet {
    public PluginSupportFileReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed, boolean init) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet", "<init>"));
        }
        super(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed, null, init);
    }

    public MyFileReference createNonPluginFileReference(TextRange range, int index, String text) {
        return new MyFileReference(this, range, index, text);
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return new Condition<PsiFileSystemItem>(){
            private final ProjectFileIndex fileIndex;
            {
                this.fileIndex = ProjectRootManager.getInstance((Project)PluginSupportFileReferenceSet.this.getElement().getProject()).getFileIndex();
            }

            public boolean value(PsiFileSystemItem psiFileSystemItem) {
                VirtualFile fileOrDir = psiFileSystemItem.getVirtualFile();
                if (fileOrDir != null && this.fileIndex.isInContent(fileOrDir)) {
                    return PluginSupportFileReferenceSet.this.isAcceptToCompletion(fileOrDir);
                }
                return false;
            }
        };
    }

    protected boolean isAcceptToCompletion(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet", "isAcceptToCompletion"));
        }
        return fileOrDir.isDirectory();
    }

    public final FileReference createFileReference(TextRange range, int index, String text) {
        if (index == 0 && text.equals("plugins") && this.isAbsolutePathReference()) {
            return new PluginDirReference(this, range, index, text);
        }
        return this.createNonPluginFileReference(range, index, text);
    }

    protected boolean isPluginMustHasVersion() {
        return false;
    }

    @Nullable
    protected VirtualFile getContextInPlugin(@NotNull VirtualFile pluginRoot) {
        if (pluginRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginRoot", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet", "getContextInPlugin"));
        }
        return pluginRoot;
    }

    protected PsiElement doSetTextToElement(String text) {
        ElementManipulator manipulator = CachingReference.getManipulator((PsiElement)this.getElement());
        return manipulator.handleContentChange(this.getElement(), text);
    }

    public static class PluginDirReference
    extends FileReference {
        public PluginDirReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
            if (fileReferenceSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$PluginDirReference", "<init>"));
            }
            super(fileReferenceSet, range, index, text);
            assert (index == 0);
            assert (text.equals("plugins"));
            assert (fileReferenceSet.isAbsolutePathReference());
        }

        @NotNull
        protected ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$PluginDirReference", "innerResolve"));
            }
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)this.getElement().getContainingFile().getOriginalFile())};
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$PluginDirReference", "innerResolve"));
            }
            return resolveResultArray;
        }
    }

    public static class MyFileReference
    extends FileReference {
        public MyFileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
            if (fileReferenceSet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "<init>"));
            }
            super(fileReferenceSet, range, index, text);
        }

        @Nullable
        private FileReference getPreviousReferenceInner() {
            return this.getIndex() == 0 ? null : this.getFileReferenceSet().getReference(this.getIndex() - 1);
        }

        @Nullable
        public FileReference getPreviousReference() {
            return this.getPreviousReferenceInner();
        }

        @NotNull
        public PluginSupportFileReferenceSet getFileReferenceSet() {
            PluginSupportFileReferenceSet pluginSupportFileReferenceSet = (PluginSupportFileReferenceSet)super.getFileReferenceSet();
            if (pluginSupportFileReferenceSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "getFileReferenceSet"));
            }
            return pluginSupportFileReferenceSet;
        }

        @NotNull
        protected final ResolveResult[] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "innerResolve"));
            }
            FileReference contextReference = this.getPreviousReference();
            if (contextReference instanceof PluginDirReference) {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
                if (module == null) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "innerResolve"));
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                String text = this.getText();
                VirtualFile pluginDir = null;
                if (this.getFileReferenceSet().isPluginMustHasVersion()) {
                    for (VirtualFile root : GrailsFramework.getInstance().getAllPluginRoots(module, false)) {
                        if (!root.getName().equals(text)) continue;
                        pluginDir = root;
                        break;
                    }
                } else {
                    pluginDir = GrailsFramework.getInstance().findPluginRoot(module, text, true);
                }
                if (pluginDir == null) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "innerResolve"));
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                VirtualFile contextInPlugin = this.getFileReferenceSet().getContextInPlugin(pluginDir);
                if (contextInPlugin == null) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "innerResolve"));
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                PsiDirectory psiPluginDir = this.getElement().getManager().findDirectory(contextInPlugin);
                if (psiPluginDir == null) {
                    if (ResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "innerResolve"));
                    }
                    return ResolveResult.EMPTY_ARRAY;
                }
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)psiPluginDir)};
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "innerResolve"));
                }
                return resolveResultArray;
            }
            ResolveResult[] resolveResultArray = super.innerResolve(caseSensitive, containingFile);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "innerResolve"));
            }
            return resolveResultArray;
        }

        @NotNull
        protected final Collection<PsiFileSystemItem> getContexts() {
            FileReference prevRef = this.getPreviousReference();
            if (prevRef instanceof PluginDirReference) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "getContexts"));
                }
                return list;
            }
            if (prevRef == null) {
                Collection collection = this.getFileReferenceSet().getDefaultContexts();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "getContexts"));
                }
                return collection;
            }
            ResolveResult[] resolveResults = prevRef.multiResolve(false);
            ArrayList<PsiFileSystemItem> result2 = new ArrayList<PsiFileSystemItem>(resolveResults.length);
            for (ResolveResult resolveResult : resolveResults) {
                if (resolveResult.getElement() == null) continue;
                result2.add((PsiFileSystemItem)resolveResult.getElement());
            }
            ArrayList<PsiFileSystemItem> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "getContexts"));
            }
            return arrayList;
        }

        protected PsiElement doRename(VirtualFile dstVFile) {
            for (PsiFileSystemItem item : this.getContexts()) {
                VirtualFile vFile = item.getVirtualFile();
                if (vFile == null || !VfsUtil.isAncestor((VirtualFile)vFile, (VirtualFile)dstVFile, (boolean)false)) continue;
                String text = this.getElement().getText().substring(this.getFileReferenceSet().getStartInElement(), this.getRangeInElement().getStartOffset());
                String path = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)vFile, (char)'/');
                if (!text.isEmpty()) {
                    path = text.endsWith("/") ? text + path : text + '/' + path;
                }
                assert (path != null);
                String newContent = this.pathToString(path);
                if (newContent == null) {
                    return this.getElement();
                }
                return this.getFileReferenceSet().doSetTextToElement(newContent);
            }
            FileReference prevRef = this.getPreviousReferenceInner();
            if (prevRef instanceof MyFileReference) {
                return ((MyFileReference)prevRef).doRename(dstVFile);
            }
            return this.getElement();
        }

        @Nullable
        protected String pathToString(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "pathToString"));
            }
            return path;
        }

        public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "bindToElement"));
            }
            PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)element;
            VirtualFile dstVFile = fileSystemItem.getVirtualFile();
            if (dstVFile == null) {
                throw new IncorrectOperationException("Cannot bind to non-physical element:" + element);
            }
            return this.doRename(dstVFile);
        }

        @NotNull
        public final Object[] getVariants() {
            if (this.getPreviousReference() instanceof PluginDirReference) {
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
                if (module == null) {
                    if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "getVariants"));
                    }
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
                Object[] objectArray = GrailsUtils.createPluginVariants(module, this.getFileReferenceSet().isPluginMustHasVersion());
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "getVariants"));
                }
                return objectArray;
            }
            Object[] objectArray = super.getVariants();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/common/PluginSupportFileReferenceSet$MyFileReference", "getVariants"));
            }
            return objectArray;
        }
    }
}

