/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.controller;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import icons.JetgroovyIcons;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;

public class ControllerReference
extends PsiPolyVariantReferenceBase<PsiElement> {
    public ControllerReference(PsiElement psiElement, boolean soft) {
        super(psiElement, soft);
    }

    public ControllerReference(PsiElement element, TextRange range, boolean soft) {
        super(element, range, soft);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        String value = this.getValue();
        if (value.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/controller/ControllerReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/controller/ControllerReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        String name = StringUtil.decapitalize((String)StringUtil.trimEnd((String)value, (String)"Controller"));
        Collection<GrClassDefinition> controllers = GrailsArtifact.CONTROLLER.getInstances(module, name);
        if (controllers.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/controller/ControllerReference", "multiResolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] res = new ResolveResult[controllers.size()];
        int i = 0;
        for (GrClassDefinition classDefinition : controllers) {
            res[i++] = new PsiElementResolveResult((PsiElement)classDefinition);
        }
        if (res == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/controller/ControllerReference", "multiResolve"));
        }
        return res;
    }

    @NotNull
    public Object[] getVariants() {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/controller/ControllerReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        MultiMap<String, GrClassDefinition> controllers = GrailsArtifact.CONTROLLER.getInstances(module);
        Object[] res = new LookupElement[controllers.size()];
        int i = 0;
        for (Map.Entry entry : controllers.entrySet()) {
            GrTypeDefinition controllerClass = (GrTypeDefinition)((Collection)entry.getValue()).iterator().next();
            res[i++] = LookupElementBuilder.create((Object)controllerClass, (String)((String)entry.getKey())).withIcon(JetgroovyIcons.Mvc.Controller);
        }
        if (res == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/references/controller/ControllerReference", "getVariants"));
        }
        return res;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiClass aClass;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/grails/references/controller/ControllerReference", "bindToElement"));
        }
        if (element instanceof PsiClass && GrailsArtifact.CONTROLLER.isInstance(aClass = (PsiClass)element)) {
            String artifactName = GrailsArtifact.CONTROLLER.getArtifactName(aClass);
            if (this.getValue().equals(artifactName)) {
                return this.getElement();
            }
        }
        return super.bindToElement(element);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (!newElementName.endsWith(GrailsArtifact.CONTROLLER.suffix)) {
            return this.getElement();
        }
        return super.handleElementRename(GrailsArtifact.CONTROLLER.getArtifactName(newElementName));
    }
}

