/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.sync;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.projectView.ShowHideKt;
import org.jetbrains.plugins.grails.references.TraitInjectorService;
import org.jetbrains.plugins.grails.service.GrailsBackgroundService;
import org.jetbrains.plugins.grails.structure.GrailsApplicationListener;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.structure.sync.GrailsRunConfigurationTask;
import org.jetbrains.plugins.grails.structure.sync.GrailsSdkCheckTask;

public class GrailsStartupActivity
implements StartupActivity {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsStartupActivity", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        MessageBusConnection connection2 = project.getMessageBus().connect();
        connection2.subscribe(GrailsApplicationListener.TOPIC, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsStartupActivity", "lambda$runActivity$1"));
            }
            GrailsBackgroundService backgroundService = GrailsBackgroundService.getInstance(project);
            if (Registry.is((String)"grails.create.run.configurations")) {
                backgroundService.run(new GrailsRunConfigurationTask(project));
            }
            backgroundService.run(new GrailsSdkCheckTask(project));
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsStartupActivity", "lambda$null$0"));
                }
                ShowHideKt.showHide(project);
            }, project.getDisposed());
        });
        connection2.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                TraitInjectorService.queueUpdate(project);
            }
        });
        GrailsApplicationManager.getInstance(project).queueUpdate();
        TraitInjectorService.queueUpdate(project);
    }
}

