/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.java.steps.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberUtil;
import org.jetbrains.plugins.cucumber.java.CucumberJavaUtil;

public class CucumberJavaStepDefinitionSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "org/jetbrains/plugins/cucumber/java/steps/search/CucumberJavaStepDefinitionSearch", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/cucumber/java/steps/search/CucumberJavaStepDefinitionSearch", "execute"));
        }
        PsiElement myElement = queryParameters.getElementToSearch();
        if (!(myElement instanceof PsiMethod)) {
            return true;
        }
        PsiMethod method = (PsiMethod)myElement;
        Boolean isStepDefinition = (Boolean)ReadAction.compute(() -> CucumberJavaUtil.isStepDefinition(method));
        if (!isStepDefinition.booleanValue()) {
            return true;
        }
        PsiAnnotation stepAnnotation = (PsiAnnotation)ReadAction.compute(() -> CucumberJavaUtil.getCucumberStepAnnotation(method));
        String regexp = CucumberJavaUtil.getPatternFromStepDefinition(stepAnnotation);
        if (regexp == null) {
            return true;
        }
        return CucumberUtil.findGherkinReferencesToElement((PsiElement)myElement, (String)regexp, consumer, (SearchScope)queryParameters.getEffectiveSearchScope());
    }
}

