/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.jetbrains.firefox.FirefoxDeclarativeScope;
import com.jetbrains.firefox.FirefoxEvaluateContext;
import com.jetbrains.firefox.FirefoxValueManager;
import com.jetbrains.firefox.rdp.Bindings;
import com.jetbrains.firefox.rdp.Frame;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrameBase;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ObjectScope;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.rpc.CommandProcessorKt;

class FirefoxCallFrame
extends CallFrameBase {
    final String scriptUrl;
    final String scriptId;
    private final Variable thisObject;

    public FirefoxCallFrame(final @NotNull FirefoxValueManager valueManager, @NotNull Frame frame, final boolean useBindingsFromFrameData) {
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/jetbrains/firefox/FirefoxCallFrame", "<init>"));
        }
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/jetbrains/firefox/FirefoxCallFrame", "<init>"));
        }
        super(FirefoxCallFrame.getFunctionName(frame.environment().function()), frame.where().line() - 1, frame.where().column(), (EvaluateContext)new FirefoxEvaluateContext(frame.actor(), valueManager));
        if (frame.source() == null) {
            this.scriptId = null;
            this.scriptUrl = frame.where().source().url();
        } else {
            this.scriptId = frame.source().actor();
            this.scriptUrl = null;
        }
        this.thisObject = frame.receiver() == null ? null : valueManager.createVariable("this", frame.receiver(), null);
        final Frame.Environment environment = frame.environment();
        this.setHasOnlyGlobalScope(environment.parent() == null);
        this.setScopes(new NotNullLazyValue(){

            @NotNull
            protected List<Scope> compute() {
                SmartList scopes = new SmartList();
                scopes.add(FirefoxCallFrame.createScope(environment, valueManager, true, useBindingsFromFrameData));
                Frame.Environment parent = environment;
                while ((parent = parent.parent()) != null) {
                    scopes.add(FirefoxCallFrame.createScope(parent, valueManager, false, useBindingsFromFrameData));
                }
                valueManager.promoteRecentlyAddedActorsToThreadLifetime();
                SmartList smartList = scopes;
                if (smartList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/firefox/FirefoxCallFrame$1", "compute"));
                }
                return smartList;
            }
        });
    }

    @NotNull
    private static Scope createScope(@NotNull Frame.Environment environment, @NotNull FirefoxValueManager valueManager, boolean local, boolean useBindingsFromFrameData) {
        ScopeType type;
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/firefox/FirefoxCallFrame", "createScope"));
        }
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/jetbrains/firefox/FirefoxCallFrame", "createScope"));
        }
        switch (environment.type()) {
            case OBJECT: {
                type = environment.parent() == null ? ScopeType.GLOBAL : ScopeType.WITH;
                break;
            }
            case WITH: {
                type = ScopeType.WITH;
                break;
            }
            default: {
                type = local ? ScopeType.LOCAL : ScopeType.CLOSURE;
            }
        }
        Bindings bindings = environment.bindings();
        if (bindings == null) {
            ObjectValue value = (ObjectValue)valueManager.createValue(environment.object(), null, null);
            CommandProcessorKt.getLOG().assertTrue(value != null);
            ObjectScope objectScope = new ObjectScope(type, value);
            if (objectScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/firefox/FirefoxCallFrame", "createScope"));
            }
            return objectScope;
        }
        FirefoxDeclarativeScope firefoxDeclarativeScope = new FirefoxDeclarativeScope(type, environment, valueManager, useBindingsFromFrameData);
        if (firefoxDeclarativeScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/firefox/FirefoxCallFrame", "createScope"));
        }
        return firefoxDeclarativeScope;
    }

    @Nullable
    static String getFunctionName(@Nullable Frame.Function function) {
        if (function == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)function.userDisplayName())) {
            return StringUtil.isEmpty((String)function.displayName()) ? StringUtil.nullize((String)function.name()) : function.displayName();
        }
        return function.userDisplayName();
    }

    @NotNull
    public Promise<Variable> getReceiverVariable() {
        Promise promise = Promise.resolve((Object)this.thisObject);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/firefox/FirefoxCallFrame", "getReceiverVariable"));
        }
        return promise;
    }

    public Object getEqualityObject() {
        return (String)ObjectUtils.chooseNotNull((Object)this.scriptId, (Object)this.scriptUrl) + "#" + this.getFunctionName();
    }
}

