/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.highlight;

import com.intellij.json.JsonFileType;
import com.intellij.lang.javascript.linter.JSLinterConfigChangeTracker;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public final class TsLintConfigFileChangeTracker
extends JSLinterConfigChangeTracker {
    public TsLintConfigFileChangeTracker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintConfigFileChangeTracker", "<init>"));
        }
        super(project, (FileType)JsonFileType.INSTANCE);
    }

    public static TsLintConfigFileChangeTracker getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintConfigFileChangeTracker", "getInstance"));
        }
        return (TsLintConfigFileChangeTracker)((Object)ServiceManager.getService((Project)project, TsLintConfigFileChangeTracker.class));
    }

    protected boolean isAnalyzerRestartNeeded(@NotNull Project project, @NotNull VirtualFile changedFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintConfigFileChangeTracker", "isAnalyzerRestartNeeded"));
        }
        if (changedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFile", "com/intellij/lang/javascript/linter/tslint/highlight/TsLintConfigFileChangeTracker", "isAnalyzerRestartNeeded"));
        }
        TsLintConfiguration configuration = TsLintConfiguration.getInstance(project);
        TsLintState state = (TsLintState)configuration.getExtendedState().getState();
        if (state.isCustomConfigFileUsed() && state.getCustomConfigFilePath() != null) {
            VirtualFile configVirtualFile = JSLinterConfigFileUtil.findLocalFileByPath((String)state.getCustomConfigFilePath());
            return changedFile.equals(configVirtualFile);
        }
        return "tslint.json".equals(changedFile.getName());
    }
}

