/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.idea.RareLogger;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.execution.TsLintConfigFileSearcher;
import com.intellij.lang.javascript.linter.tslint.execution.TsLintOutputJsonParser;
import com.intellij.lang.javascript.linter.tslint.execution.TsLinterError;
import com.intellij.lang.javascript.linter.tslint.service.commands.TsLintFixErrorsCommand;
import com.intellij.lang.javascript.linter.tslint.service.commands.TsLintGetErrorsCommand;
import com.intellij.lang.javascript.linter.tslint.service.protocol.TsLintLanguageServiceProtocol;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLintLanguageService
extends JSLanguageServiceBase {
    @NotNull
    private static final Logger LOG = RareLogger.wrap((Logger)Logger.getInstance((String)"#com.intellij.lang.javascript.linter.tslint.service.TsLintLanguageService"), (boolean)false);
    @NotNull
    private final TsLintConfigFileSearcher myConfigFileSearcher;

    @NotNull
    public static TsLintLanguageService getService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "getService"));
        }
        TsLintLanguageService tsLintLanguageService = (TsLintLanguageService)((Object)ServiceManager.getService((Project)project, TsLintLanguageService.class));
        if (tsLintLanguageService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "getService"));
        }
        return tsLintLanguageService;
    }

    public TsLintLanguageService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "<init>"));
        }
        super(project);
        this.myConfigFileSearcher = new TsLintConfigFileSearcher();
    }

    @NotNull
    protected String getProcessName() {
        if ("TSLint" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "getProcessName"));
        }
        return "TSLint";
    }

    public final Future<List<TsLinterError>> highlight(@Nullable VirtualFile virtualFile, @Nullable VirtualFile config, @Nullable String content) {
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return new FixedFuture(Collections.singletonList(new TsLinterError(JSLanguageServiceUtil.getLanguageServiceCreationError((LinterLanguageServiceClient)this))));
        }
        MyParameters parameters = MyParameters.checkParameters(virtualFile, config, process);
        if (parameters.getErrors() != null) {
            return new FixedFuture(parameters.getErrors());
        }
        TsLintGetErrorsCommand command = new TsLintGetErrorsCommand(parameters.getPath(), parameters.getConfigPath(), StringUtil.notNullize((String)content));
        return process.execute((JSLanguageServiceCommand)command, TsLintLanguageService.createHighlightProcessor(parameters.getPath()));
    }

    public final Future<List<TsLinterError>> highlightAndFix(@Nullable VirtualFile virtualFile, @NotNull TsLintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "highlightAndFix"));
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return new FixedFuture(Collections.singletonList(new TsLinterError(JSLanguageServiceUtil.getLanguageServiceCreationError((LinterLanguageServiceClient)this))));
        }
        VirtualFile config = virtualFile == null ? null : this.myConfigFileSearcher.getConfig(state, virtualFile);
        MyParameters parameters = MyParameters.checkParameters(virtualFile, config, process);
        if (parameters.getErrors() != null) {
            return new FixedFuture(parameters.getErrors());
        }
        TsLintFixErrorsCommand command = new TsLintFixErrorsCommand(parameters.getPath(), parameters.getConfigPath());
        return process.execute((JSLanguageServiceCommand)command, TsLintLanguageService.createHighlightProcessor(parameters.getPath()));
    }

    @NotNull
    private static JSLanguageServiceCommandProcessor<List<TsLinterError>> createHighlightProcessor(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "createHighlightProcessor"));
        }
        JSLanguageServiceCommandProcessor jSLanguageServiceCommandProcessor = (object, answer) -> {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "lambda$createHighlightProcessor$0"));
            }
            return TsLintLanguageService.parseResults(answer, path);
        };
        if (jSLanguageServiceCommandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "createHighlightProcessor"));
        }
        return jSLanguageServiceCommandProcessor;
    }

    @Nullable
    private static List<TsLinterError> parseResults(@NotNull JSLanguageServiceAnswer answer, @NotNull String path) {
        if (answer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "parseResults"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "parseResults"));
        }
        JsonObject element = answer.getElement();
        JsonElement error = element.get("error");
        if (error != null) {
            return Collections.singletonList(new TsLinterError(error.getAsString()));
        }
        JsonElement body = TsLintLanguageService.parseBody(element);
        if (body == null) {
            return null;
        }
        String version = element.get("version").getAsString();
        SemVer tsLintVersion = SemVer.parseFromText((String)version);
        boolean isZeroBased = TsLintOutputJsonParser.isVersionZeroBased(tsLintVersion);
        TsLintOutputJsonParser parser = new TsLintOutputJsonParser(path, body, isZeroBased);
        return ContainerUtil.newArrayList(parser.getErrors());
    }

    private static JsonElement parseBody(@NotNull JsonObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService", "parseBody"));
        }
        JsonElement body = element.get("body");
        if (body == null) {
            return null;
        }
        if (body.isJsonPrimitive() && body.getAsJsonPrimitive().isString()) {
            String bodyContent = StringUtil.unquoteString((String)body.getAsJsonPrimitive().getAsString());
            if (!StringUtil.isEmptyOrSpaces((String)bodyContent)) {
                try {
                    return new JsonParser().parse(bodyContent);
                }
                catch (JsonParseException e) {
                    LOG.info(String.format("Problem parsing body: '%s'\n%s", body, e.getMessage()), (Throwable)e);
                }
            }
        } else {
            LOG.info(String.format("Error body type, should be a string with json inside. Body:'%s'", body.getAsString()));
        }
        return null;
    }

    protected final JSLanguageServiceQueue createLanguageServiceQueue() {
        TsLintLanguageServiceProtocol protocol = new TsLintLanguageServiceProtocol(this.myProject, el -> {});
        return new JSLanguageServiceQueueImpl(this.myProject, (JSLanguageServiceProtocol)protocol, this.myProcessConnector, this.myDefaultReporter, (JSLanguageServiceCacheData)new JSLanguageServiceDefaultCacheData());
    }

    protected final boolean needInitToolWindow() {
        return false;
    }

    private static class MyParameters {
        @NotNull
        private final String myConfigPath;
        @NotNull
        private final String myPath;
        @Nullable
        private final List<TsLinterError> myErrors;

        private MyParameters(@NotNull String path, @NotNull String configPath, @Nullable List<TsLinterError> errors) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$MyParameters", "<init>"));
            }
            if (configPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$MyParameters", "<init>"));
            }
            this.myConfigPath = configPath;
            this.myPath = path;
            this.myErrors = errors;
        }

        public static MyParameters checkParameters(@Nullable VirtualFile virtualFile, @Nullable VirtualFile config, @Nullable JSLanguageServiceQueue process) {
            String error;
            if (process == null) {
                error = "Can not create language service";
            } else if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
                error = "Path not specified";
            } else if (config == null) {
                error = "Config file was not found.";
            } else {
                String configPath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks((VirtualFile)config);
                String path = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks((VirtualFile)virtualFile);
                if (configPath != null && path != null) {
                    return new MyParameters(path, configPath, null);
                }
                error = "Can not work with the path: " + (path != null ? path : configPath);
            }
            return new MyParameters("", "", Collections.singletonList(new TsLinterError(error)));
        }

        @NotNull
        public String getConfigPath() {
            String string = this.myConfigPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$MyParameters", "getConfigPath"));
            }
            return string;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$MyParameters", "getPath"));
            }
            return string;
        }

        @Nullable
        public List<TsLinterError> getErrors() {
            return this.myErrors;
        }
    }
}

