/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.compiler;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.compiler.J2MEPreverifier;
import com.intellij.j2meplugin.compiler.MobileMakeUtil;
import com.intellij.j2meplugin.module.J2MEModuleExtension;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.J2MEModuleType;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.EmptyValidityState;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.PackagingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashSet;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class J2MEPackagingCompiler
implements PackagingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");
    private String myJarPath;
    private String myJadPath;
    private String myExplodedJarPath;
    private String myExplodedJadPath;
    private final J2MEPreverifier myJ2MEPreverifier;
    @NonNls
    private static final String META_INF = "META-INF";

    public J2MEPackagingCompiler(J2MEPreverifier j2mePreverifier) {
        this.myJ2MEPreverifier = j2mePreverifier;
    }

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(CompileContext context) {
        Module[] affectedModules = (Module[])ReadAction.compute(() -> context.getCompileScope().getAffectedModules());
        if (affectedModules == null || affectedModules.length == 0) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/compiler/J2MEPackagingCompiler", "getProcessingItems"));
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        ArrayList<MyProcessingItem> result = new ArrayList<MyProcessingItem>();
        for (Module module : affectedModules) {
            if (!ModuleType.get((Module)module).equals((Object)J2MEModuleType.getInstance())) continue;
            this.setPaths(module);
            VirtualFile moduleOutputDirectory = context.getModuleOutputDirectory(module);
            if (moduleOutputDirectory == null) continue;
            result.add(new MyProcessingItem(moduleOutputDirectory, module));
        }
        FileProcessingCompiler.ProcessingItem[] processingItemArray = result.toArray(new FileProcessingCompiler.ProcessingItem[result.size()]);
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/compiler/J2MEPackagingCompiler", "getProcessingItems"));
        }
        return processingItemArray;
    }

    private void setPaths(Module module) {
        MobileApplicationType mobileApplicationType = J2MEModuleProperties.getInstance(module).getMobileApplicationType();
        MobileModuleSettings settings = MobileModuleSettings.getInstance(module);
        LOG.assertTrue(settings != null);
        this.myJarPath = settings.getSettings().get(mobileApplicationType.getJarUrlSettingName());
        this.myJadPath = settings.getMobileDescriptionPath();
        ApplicationManager.getApplication().runReadAction(() -> {
            VirtualFile explodedDir = J2MEModuleExtension.getInstance(module).getExplodedDirectory();
            if (explodedDir != null) {
                String explodedJarPath = this.myJarPath.replace(File.separatorChar, '/');
                this.myExplodedJarPath = explodedDir.getPath() + "/" + explodedJarPath.substring(explodedJarPath.lastIndexOf(47) + 1);
                String explodedJadPath = this.myJadPath.replace(File.separatorChar, '/');
                this.myExplodedJadPath = explodedDir.getPath() + "/" + explodedJadPath.substring(explodedJadPath.lastIndexOf(47) + 1);
            } else {
                this.myExplodedJadPath = null;
                this.myExplodedJarPath = null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        ProgressIndicator progressIndicator = context.getProgressIndicator();
        progressIndicator.pushState();
        try {
            progressIndicator.setText(J2MEBundle.message("compiler.packaging.progress.title", new Object[0]));
            ArrayList<FileProcessingCompiler.ProcessingItem> result = new ArrayList<FileProcessingCompiler.ProcessingItem>();
            for (int i = 0; items != null && i < items.length; ++i) {
                Module module = ((MyProcessingItem)items[i]).getModule();
                try {
                    File jarFile = (File)ReadAction.compute(() -> {
                        try {
                            return J2MEPackagingCompiler.makeJar(context, FileUtilRt.ALL_FILES, this.myJ2MEPreverifier.getModulePreverifiedClasses(module), module);
                        }
                        catch (IOException e) {
                            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                            return null;
                        }
                    });
                    if (jarFile == null) continue;
                    MobileModuleSettings settings = MobileModuleSettings.getInstance(module);
                    this.setPaths(module);
                    MobileMakeUtil.makeJad(settings, true);
                    if (this.myExplodedJarPath != null && this.myExplodedJadPath != null) {
                        String jadPath;
                        if (!jarFile.getPath().replace(File.separatorChar, '/').equals(this.myExplodedJarPath)) {
                            FileUtil.copy((File)jarFile, (File)new File(this.myExplodedJarPath));
                        }
                        if (!(jadPath = settings.getMobileDescriptionPath().replace(File.separatorChar, '/')).equals(this.myExplodedJadPath)) {
                            FileUtil.copy((File)new File(jadPath), (File)new File(this.myExplodedJadPath));
                        }
                    }
                    result.add(items[i]);
                    continue;
                }
                catch (Exception e) {
                    context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                }
            }
            FileProcessingCompiler.ProcessingItem[] processingItemArray = result.toArray(new FileProcessingCompiler.ProcessingItem[result.size()]);
            return processingItemArray;
        }
        finally {
            progressIndicator.popState();
        }
    }

    @NotNull
    public String getDescription() {
        String string = J2MEBundle.message("compiler.packaging", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/compiler/J2MEPackagingCompiler", "getDescription"));
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return new EmptyValidityState();
    }

    private static File makeJar(CompileContext context, FileFilter fileFilter, File myDirectoryToJar, Module module) throws IOException {
        JarOutputStream jarOutputStream;
        MobileModuleSettings settings = MobileModuleSettings.getInstance(module);
        File jarFile = new File(settings.getJarURL());
        FileUtil.createParentDirs((File)jarFile);
        File manifest = settings.getManifest();
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(jarFile));
        if (manifest != null) {
            jarOutputStream = new JarOutputStream(fos);
            ZipUtil.addFileToZip((ZipOutputStream)jarOutputStream, (File)manifest, (String)"META-INF/MANIFEST.MF", null, (FileFilter)fileFilter);
        } else {
            jarOutputStream = new JarOutputStream((OutputStream)fos, new Manifest());
        }
        THashSet writtenItemRelativePaths = new THashSet();
        boolean ok = J2MEPackagingCompiler.jarLibraries(module, jarOutputStream, jarFile, fileFilter, (THashSet<String>)writtenItemRelativePaths, true);
        if (!(ok &= ZipUtil.addDirToZipRecursively((ZipOutputStream)jarOutputStream, (File)jarFile, (File)myDirectoryToJar, (String)"", (FileFilter)fileFilter, (Set)writtenItemRelativePaths))) {
            String message = J2MEBundle.message("compiler.packaging.fail", new Object[0]);
            context.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
        }
        jarOutputStream.close();
        return jarFile;
    }

    private static boolean jarLibraries(Module module, JarOutputStream jarOutputStream, File jarFile, FileFilter fileFilter, THashSet<String> writtenItemRelativePaths, boolean ok) throws IOException {
        String[] urls;
        for (String url : urls = OrderEnumerator.orderEntries((Module)module).librariesOnly().classes().getUrls()) {
            String protocol = VirtualFileManager.extractProtocol((String)url);
            String path = VfsUtilCore.urlToPath((String)url);
            if ("jar".equals(protocol)) {
                VirtualFile libraryFile = JarFileSystem.getInstance().findFileByPath(path);
                File tempFile = FileUtil.createTempDirectory((String)"temp", (String)"temp");
                tempFile.deleteOnExit();
                ZipUtil.extract((File)VfsUtilCore.virtualToIoFile((VirtualFile)libraryFile), (File)tempFile, (dir, name) -> !dir.getName().equals(META_INF));
                ok &= ZipUtil.addFileOrDirRecursively((ZipOutputStream)jarOutputStream, (File)jarFile, (File)tempFile, (String)"", (FileFilter)fileFilter, writtenItemRelativePaths);
                continue;
            }
            ok &= ZipUtil.addFileOrDirRecursively((ZipOutputStream)jarOutputStream, (File)jarFile, (File)new File(path), (String)"", (FileFilter)fileFilter, writtenItemRelativePaths);
        }
        return ok;
    }

    public void processOutdatedItem(CompileContext context, String url, ValidityState state) {
    }

    private static class MyProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private EmptyValidityState myValidityState;
        private final VirtualFile myOutputClasses;
        private final Module myModule;

        MyProcessingItem(VirtualFile outputClasses, Module module) {
            this.myOutputClasses = outputClasses;
            this.myModule = module;
            this.setValidityState();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myOutputClasses;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/compiler/J2MEPackagingCompiler$MyProcessingItem", "getFile"));
            }
            return virtualFile;
        }

        public VirtualFile getOutputClasses() {
            return this.myOutputClasses;
        }

        public Module getModule() {
            return this.myModule;
        }

        public EmptyValidityState getValidityState() {
            return this.myValidityState;
        }

        void setValidityState() {
            this.myValidityState = new EmptyValidityState();
        }
    }
}

