/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.i18n;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.i18n.CreateMobileResourcePackAction;
import com.intellij.j2meplugin.i18n.ResourceBeansContainer;
import com.intellij.j2meplugin.module.J2MEModuleType;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobileResourceBundleManager
extends ResourceBundleManager {
    private static final Logger LOG = Logger.getInstance(MobileResourceBundleManager.class);

    public MobileResourceBundleManager(Project project) {
        super(project);
    }

    @Nullable
    public PsiClass getResourceBundle() {
        return ResourceBeansContainer.getInstance(this.myProject).getResourceBundle();
    }

    @NonNls
    public String getTemplateName() {
        return "Mobile I18N.java";
    }

    @NonNls
    public String getConcatenationTemplateName() {
        return "Mobile I18N Concatenation.java";
    }

    public boolean isActive(PsiFile context) throws ResourceBundleManager.ResourceBundleNotFoundException {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)context);
        if (module != null && ModuleType.get((Module)module) == J2MEModuleType.getInstance()) {
            if (this.getResourceBundle() != null) {
                return true;
            }
            throw new ResourceBundleManager.ResourceBundleNotFoundException(J2MEBundle.message("resource.bundle.not.found.dialog.title", new Object[0]), (IntentionAction)new SetupResourceBundleFix());
        }
        return false;
    }

    public boolean canShowJavaCodeInfo() {
        return false;
    }

    private class SetupResourceBundleFix
    implements IntentionAction {
        private SetupResourceBundleFix() {
        }

        @NotNull
        public String getText() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/i18n/MobileResourceBundleManager$SetupResourceBundleFix", "getText"));
            }
            return "";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/i18n/MobileResourceBundleManager$SetupResourceBundleFix", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/j2meplugin/i18n/MobileResourceBundleManager$SetupResourceBundleFix", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/j2meplugin/i18n/MobileResourceBundleManager$SetupResourceBundleFix", "invoke"));
            }
            PsiDirectory containingDirectory = file.getContainingDirectory();
            String createItem = J2MEBundle.message("resource.bundle.not.found.create", new Object[0]);
            String chooseItem = J2MEBundle.message("resource.bundle.not.found.choose", new Object[0]);
            int item = Messages.showChooseDialog((Project)project, (String)J2MEBundle.message("resource.bundle.not.found.dialog.message", new Object[0]), (String)J2MEBundle.message("resource.bundle.not.found.dialog.title", new Object[0]), (Icon)Messages.getWarningIcon(), (String[])new String[]{createItem, chooseItem}, (String)createItem);
            if (item == 0) {
                PsiDirectory[] directories;
                PsiPackage aPackage;
                VirtualFile virtualFile = file.getVirtualFile();
                LOG.assertTrue(virtualFile != null);
                Module module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
                PackageChooserDialog chooser = new PackageChooserDialog(J2MEBundle.message("resource.bundle.destination.chooser.title", new Object[0]), MobileResourceBundleManager.this.myProject);
                if (file instanceof PsiJavaFile) {
                    chooser.selectPackage(((PsiJavaFile)file).getPackageName());
                }
                if (chooser.showAndGet() && (aPackage = chooser.getSelectedPackage()) != null && (directories = aPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module))).length > 0) {
                    new CreateMobileResourcePackAction().invokeDialog(project, directories[0]);
                }
            } else if (item == 1) {
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createProjectScopeChooser(chooseItem);
                chooser.selectDirectory(containingDirectory);
                chooser.showDialog();
                PsiClass selectedClass = chooser.getSelected();
                if (selectedClass != null) {
                    ResourceBeansContainer.getInstance(project).registerResourceBundle(selectedClass);
                }
            }
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

