/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings.ui;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.j2meplugin.module.J2MEModuleBuilder;
import com.intellij.j2meplugin.module.settings.ui.MobileBuildPanel;
import com.intellij.j2meplugin.module.settings.ui.MobileExplodedPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;

public class J2MEModuleExplodedDirStep
extends ModuleWizardStep {
    private final J2MEModuleBuilder myModuleBuilder;
    private final Icon myIcon;
    private final String myHelpId;
    private MobileExplodedPanel myExplodedPanel;
    private MobileBuildPanel myBuildPanel;
    private String myDefaultExplodedPath;

    public J2MEModuleExplodedDirStep(WizardContext wizardContext, J2MEModuleBuilder moduleBuilder, Icon wizardIcon, @NonNls String s) {
        this.myModuleBuilder = moduleBuilder;
        this.myIcon = wizardIcon;
        this.myHelpId = s;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myBuildPanel.getPreferredFocusedComponent();
    }

    public JComponent getComponent() {
        String output = "output";
        this.myDefaultExplodedPath = this.myModuleBuilder.getModuleFileDirectory() != null ? this.myModuleBuilder.getModuleFileDirectory().replace('/', File.separatorChar) + File.separator + "output" : "";
        this.myExplodedPanel = new MobileExplodedPanel(this.myModuleBuilder.getExplodedDirPath() != null, this.myModuleBuilder.isExcludeFromContent(), this.myModuleBuilder.isDefaultEDirectoryModified() && this.myModuleBuilder.getExplodedDirPath() != null ? this.myModuleBuilder.getExplodedDirPath() : this.myDefaultExplodedPath);
        this.myBuildPanel = new MobileBuildPanel(this.myModuleBuilder.getMobileApplicationType(), null, this.myModuleBuilder.getMobileModuleSettings());
        JPanel myWholePanel = new JPanel(new GridBagLayout());
        myWholePanel.add((Component)this.myBuildPanel.createComponent(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)5), 0, 0));
        myWholePanel.add((Component)this.myExplodedPanel.getComponent(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.insets((int)5), 0, 0));
        myWholePanel.setBorder(BorderFactory.createEtchedBorder());
        return myWholePanel;
    }

    public void updateDataModel() {
        this.storeDifference();
    }

    public boolean validate() throws ConfigurationException {
        this.myBuildPanel.apply();
        return true;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    public void onStepLeaving() {
        this.myExplodedPanel.apply();
        this.storeDifference();
        try {
            this.myBuildPanel.apply();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    private void storeDifference() {
        if (this.myExplodedPanel.isPathEnabled()) {
            this.myModuleBuilder.setExplodedDirPath(this.myExplodedPanel.getExplodedDir());
            this.myModuleBuilder.setExcludeFromContent(this.myExplodedPanel.isExcludeFromContent());
            this.myModuleBuilder.setDefaultEDirectoryModified(!this.myDefaultExplodedPath.equals(this.myExplodedPanel.getExplodedDir()));
        } else {
            this.myModuleBuilder.setExplodedDirPath(null);
        }
    }
}

