/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.dbimport;

import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.ExecuteBatchQuery;
import com.intellij.database.remote.dbimport.QueryWithParameters;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import com.intellij.util.Consumer;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;

public class PreparedBatchQuery
extends QueryWithParameters {
    private final List<PreparedBatchQuery> myPreviousBatchQueries;
    private boolean myExecuted;

    PreparedBatchQuery(@NotNull Rdbms rdbms, @NotNull BatchRecords parameters, @NotNull RemotePreparedStatement preparedStatement, @NotNull Consumer<ErrorRecord> errorConsumer, @NotNull List<ColumnInfo> infos, @NotNull List<PreparedBatchQuery> queries) {
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/dbimport/PreparedBatchQuery", "<init>"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/remote/dbimport/PreparedBatchQuery", "<init>"));
        }
        if (preparedStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preparedStatement", "com/intellij/database/remote/dbimport/PreparedBatchQuery", "<init>"));
        }
        if (errorConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorConsumer", "com/intellij/database/remote/dbimport/PreparedBatchQuery", "<init>"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/database/remote/dbimport/PreparedBatchQuery", "<init>"));
        }
        if (queries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queries", "com/intellij/database/remote/dbimport/PreparedBatchQuery", "<init>"));
        }
        super(rdbms, parameters, preparedStatement, infos, errorConsumer);
        this.myPreviousBatchQueries = queries;
    }

    @Override
    void statementCompleted() throws RemoteException, SQLException {
        this.myPreparedStatement.addBatch();
    }

    public void executeWithoutBatch() throws RemoteException, SQLException {
        if (this.myExecuted) {
            return;
        }
        this.myExecuted = true;
        try {
            this.completeStatement();
            this.myPreparedStatement.executeUpdate();
        }
        catch (RemoteBatchPreparedStatementImpl.IllegalTransactionStateException e) {
            throw e;
        }
        catch (SQLException ex) {
            this.executeWithoutMultiLines();
        }
    }

    @Override
    protected void onError() throws RemoteException, SQLException {
        this.myPreparedStatement.clearBatch();
        ExecuteBatchQuery.executeWithoutBatch(this.myPreviousBatchQueries, this.myPreviousBatchQueries.size());
        this.executeWithoutBatch();
    }
}

