/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public final class SpringMvcLibraryUtil {
    public static final PatternCondition<PsiElement> IS_SPRING_MVC_PROJECT = new PatternCondition<PsiElement>("isSpringMVCEnabledProject"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/SpringMvcLibraryUtil$1", "accepts"));
            }
            return SpringMvcLibraryUtil.isSpringMVCEnabled(element.getProject());
        }
    };

    public static boolean hasSpringMvcLibrary(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/web/mvc/SpringMvcLibraryUtil", "hasSpringMvcLibrary"));
        }
        return JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.web.servlet.DispatcherServlet", ProjectScope.getLibrariesScope((Project)project)) != null;
    }

    public static boolean hasSpringMvcLibrary(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/web/mvc/SpringMvcLibraryUtil", "hasSpringMvcLibrary"));
        }
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.DispatcherServlet") != null;
    }

    public static boolean isSpringMVCEnabled(Project project) {
        return SpringCommonUtils.hasSpringFacets((Project)project) && ProjectFacetManager.getInstance((Project)project).hasFacets(WebFacet.ID) && SpringMvcLibraryUtil.hasSpringMvcLibrary(project);
    }
}

