/*
 * Decompiled with CFR 0.152.
 */
package git4idea.cherrypick;

import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import git4idea.GitApplyChangesProcess;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import org.jetbrains.annotations.NotNull;

public class GitCherryPicker
extends VcsCherryPicker {
    private static final Logger LOG = Logger.getInstance(GitCherryPicker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;

    public GitCherryPicker(@NotNull Project project, @NotNull Git git) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/cherrypick/GitCherryPicker", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/cherrypick/GitCherryPicker", "<init>"));
        }
        this.myProject = project;
        this.myGit = git;
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
    }

    public void cherryPick(@NotNull List<VcsFullCommitDetails> commits2) {
        if (commits2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/cherrypick/GitCherryPicker", "cherryPick"));
        }
        GitApplyChangesProcess applyProcess = new GitApplyChangesProcess(this.myProject, commits2, this.isAutoCommit(), "cherry-pick", "applied", (Function4<? super GitRepository, ? super Hash, ? super Boolean, ? super List<? extends GitLineHandlerListener>, ? extends GitCommandResult>)((Function4)(repository, commit, autoCommit, listeners) -> this.myGit.cherryPick((GitRepository)repository, commit.asString(), (boolean)autoCommit, (GitLineHandlerListener[])ArrayUtil.toObjectArray((Collection)listeners, GitLineHandlerListener.class))), (Function1<? super GitCommandResult, Boolean>)((Function1)result2 -> GitCherryPicker.isNothingToCommitMessage(result2)), (Function1<? super VcsFullCommitDetails, String>)((Function1)commit -> GitCherryPicker.createCommitMessage(commit)), (Function1<? super Collection<? extends Change>, ? extends Collection<? extends Change>>)((Function1)originalChanges -> GitUtil.findCorrespondentLocalChanges(ChangeListManager.getInstance((Project)this.myProject), originalChanges)), true, (Function1<? super GitRepository, Unit>)((Function1)repository -> this.cancelCherryPick((GitRepository)repository)));
        applyProcess.execute();
    }

    private static boolean isNothingToCommitMessage(@NotNull GitCommandResult result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "git4idea/cherrypick/GitCherryPicker", "isNothingToCommitMessage"));
        }
        String stdout = result2.getOutputAsJoinedString();
        return stdout.contains("nothing to commit") || stdout.contains("previous cherry-pick is now empty");
    }

    @NotNull
    private static String createCommitMessage(@NotNull VcsFullCommitDetails commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/cherrypick/GitCherryPicker", "createCommitMessage"));
        }
        String string = commit.getFullMessage() + "\n\n(cherry picked from commit " + ((Hash)commit.getId()).toShortString() + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker", "createCommitMessage"));
        }
        return string;
    }

    private Unit cancelCherryPick(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/cherrypick/GitCherryPicker", "cancelCherryPick"));
        }
        if (this.isAutoCommit()) {
            GitCherryPicker.removeCherryPickHead(repository);
        }
        return Unit.INSTANCE;
    }

    private static void removeCherryPickHead(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/cherrypick/GitCherryPicker", "removeCherryPickHead"));
        }
        File cherryPickHeadFile = repository.getRepositoryFiles().getCherryPickHead();
        if (cherryPickHeadFile.exists()) {
            boolean deleted = FileUtil.delete((File)cherryPickHeadFile);
            if (!deleted) {
                LOG.warn("Couldn't delete " + cherryPickHeadFile);
            }
        } else {
            LOG.info("Cancel cherry-pick in " + repository.getPresentableUrl() + ": no CHERRY_PICK_HEAD found");
        }
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        if (vcsKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker", "getSupportedVcs"));
        }
        return vcsKey;
    }

    @NotNull
    public String getActionTitle() {
        if ("Cherry-Pick" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/cherrypick/GitCherryPicker", "getActionTitle"));
        }
        return "Cherry-Pick";
    }

    private boolean isAutoCommit() {
        return GitVcsSettings.getInstance(this.myProject).isAutoCommitOnCherryPick();
    }

    public boolean canHandleForRoots(@NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/cherrypick/GitCherryPicker", "canHandleForRoots"));
        }
        return roots.stream().allMatch(r -> this.myRepositoryManager.getRepositoryForRoot((VirtualFile)r) != null);
    }

    public String getInfo(@NotNull VcsLog log, @NotNull Map<VirtualFile, List<Hash>> commits2) {
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "git4idea/cherrypick/GitCherryPicker", "getInfo"));
        }
        if (commits2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/cherrypick/GitCherryPicker", "getInfo"));
        }
        int commitsNum = commits2.values().size();
        for (VirtualFile root : commits2.keySet()) {
            GitRepository repository = (GitRepository)ObjectUtils.assertNotNull((Object)this.myRepositoryManager.getRepositoryForRoot(root));
            for (Hash commit : commits2.get(root)) {
                GitLocalBranch currentBranch = repository.getCurrentBranch();
                Collection containingBranches = log.getContainingBranches(commit, root);
                if (currentBranch == null || containingBranches == null || !containingBranches.contains(currentBranch.getName())) continue;
                return String.format("The current branch already contains %s the selected %s", commitsNum > 1 ? "one of" : "", StringUtil.pluralize((String)"commit", (int)commitsNum));
            }
        }
        return null;
    }
}

