/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogUtil;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

abstract class GitLogRecordCollector
implements Consumer<GitLogRecord> {
    private static final Logger LOG = Logger.getInstance(GitLogRecordCollector.class);
    private static final int STATUS_LINES_THRESHOLD = 20000;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final MultiMap<String, GitLogRecord> myHashToRecord;
    @NotNull
    private final MultiMap<String, GitLogRecord> myHashToIncompleteRecords;
    private int myIncompleteStatusLinesCount;

    protected GitLogRecordCollector(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitLogRecordCollector", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitLogRecordCollector", "<init>"));
        }
        this.myHashToRecord = MultiMap.createLinked();
        this.myHashToIncompleteRecords = MultiMap.createLinked();
        this.myIncompleteStatusLinesCount = 0;
        this.myProject = project;
        this.myRoot = root;
    }

    public void consume(@NotNull GitLogRecord record) {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "git4idea/history/GitLogRecordCollector", "consume"));
        }
        String[] parents = record.getParentsHashes();
        if (parents.length <= 1) {
            this.consume(Collections.singletonList(record));
        } else {
            this.myHashToRecord.putValue((Object)record.getHash(), (Object)record);
            if (parents.length == this.myHashToRecord.get((Object)record.getHash()).size()) {
                this.processCollectedRecords(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCollectedRecords(boolean processIncompleteRecords) {
        for (String hash : this.myHashToRecord.keySet()) {
            ArrayList records = ContainerUtil.newArrayList((Iterable)((Iterable)ObjectUtils.notNull((Object)this.myHashToRecord.get((Object)hash))));
            GitLogRecord firstRecord = (GitLogRecord)records.get(0);
            if (firstRecord.getParentsHashes().length != 0 && records.size() != firstRecord.getParentsHashes().length) {
                this.myHashToIncompleteRecords.put((Object)hash, (Collection)records);
                records.forEach(r -> this.myIncompleteStatusLinesCount += r.getStatusInfos().size());
                continue;
            }
            this.consume(records);
        }
        this.myHashToRecord.clear();
        if (!this.myHashToIncompleteRecords.isEmpty() && (processIncompleteRecords || this.myIncompleteStatusLinesCount >= 20000)) {
            try {
                Map<String, String> hashToTreeMap = this.getHashToTreeMap(ContainerUtil.map((Collection)this.myHashToIncompleteRecords.entrySet(), e -> (GitLogRecord)ContainerUtil.getFirstItem((Collection)((Collection)e.getValue()))));
                for (String hash : this.myHashToIncompleteRecords.keySet()) {
                    ArrayList records = ContainerUtil.newArrayList((Iterable)((Iterable)ObjectUtils.notNull((Object)this.myHashToIncompleteRecords.get((Object)hash))));
                    GitLogRecordCollector.fillWithEmptyRecords(records, hashToTreeMap);
                    this.consume(records);
                }
            }
            catch (VcsException e2) {
                LOG.error((Throwable)e2);
            }
            finally {
                this.myHashToIncompleteRecords.clear();
                this.myIncompleteStatusLinesCount = 0;
            }
        }
    }

    public void finish() {
        this.processCollectedRecords(true);
    }

    public abstract void consume(@NotNull List<GitLogRecord> var1);

    @NotNull
    private Map<String, String> getHashToTreeMap(@NotNull Collection<GitLogRecord> records) throws VcsException {
        if (records == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "git4idea/history/GitLogRecordCollector", "getHashToTreeMap"));
        }
        HashSet hashes2 = ContainerUtil.newHashSet();
        for (GitLogRecord r : records) {
            hashes2.add(r.getHash());
            hashes2.addAll(Arrays.asList(r.getParentsHashes()));
        }
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, this.myRoot, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(this.myProject, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.TREE);
        GitVcs vcs = (GitVcs)((Object)ObjectUtils.notNull((Object)((Object)GitVcs.getInstance(this.myProject))));
        handler.setStdoutSuppressed(true);
        handler.addParameters(parser.getPretty());
        handler.addParameters(GitLogUtil.getNoWalkParameter(vcs));
        handler.addParameters("--stdin");
        handler.endOptions();
        GitLogUtil.sendHashesToStdin(vcs, hashes2, handler);
        String output = handler.run();
        if (!handler.errors().isEmpty()) {
            throw new VcsException(GitUIUtil.stringifyErrors(handler.errors()));
        }
        List<GitLogRecord> hashAndTreeRecords = parser.parse(output);
        Map map = ContainerUtil.map2Map(hashAndTreeRecords, record -> Pair.create((Object)record.getHash(), (Object)record.getTreeHash()));
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogRecordCollector", "getHashToTreeMap"));
        }
        return map;
    }

    private static void fillWithEmptyRecords(@NotNull List<GitLogRecord> records, @NotNull Map<String, String> hashToTreeMap) {
        if (records == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "git4idea/history/GitLogRecordCollector", "fillWithEmptyRecords"));
        }
        if (hashToTreeMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashToTreeMap", "git4idea/history/GitLogRecordCollector", "fillWithEmptyRecords"));
        }
        GitLogRecord firstRecord = records.get(0);
        String commit = firstRecord.getHash();
        String[] parents = firstRecord.getParentsHashes();
        String commitTreeHash = hashToTreeMap.get(commit);
        LOG.assertTrue(commitTreeHash != null, (Object)("Could not get tree hash for commit " + commit));
        for (int parentIndex = 0; parentIndex < parents.length; ++parentIndex) {
            String parent = parents[parentIndex];
            String parentTreeHash = hashToTreeMap.get(parent);
            LOG.assertTrue(parentTreeHash != null, (Object)("Could not get tree hash for commit " + parent));
            if (!parentTreeHash.equals(commitTreeHash) || records.size() >= parents.length) continue;
            records.add(parentIndex, new GitLogRecord(firstRecord.getOptions(), ContainerUtil.emptyList(), ContainerUtil.emptyList(), firstRecord.isSupportsRawBody()));
        }
    }
}

