/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitChangeUtils;
import git4idea.util.GitFileUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogDiffHandler
implements VcsLogDiffHandler {
    private static final Logger LOG = Logger.getInstance(GitLogDiffHandler.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final DiffContentFactoryEx myDiffContentFactory;

    public GitLogDiffHandler(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/log/GitLogDiffHandler", "<init>"));
        }
        this.myProject = project;
        this.myDiffContentFactory = DiffContentFactoryEx.getInstanceEx();
    }

    public void showDiff(final @NotNull VirtualFile root, final @Nullable FilePath leftPath, final @NotNull Hash leftHash, final @Nullable FilePath rightPath, final @NotNull Hash rightHash) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogDiffHandler", "showDiff"));
        }
        if (leftHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftHash", "git4idea/log/GitLogDiffHandler", "showDiff"));
        }
        if (rightHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightHash", "git4idea/log/GitLogDiffHandler", "showDiff"));
        }
        if (leftPath == null && rightPath == null) {
            return;
        }
        if (((FilePath)ObjectUtils.chooseNotNull((Object)leftPath, (Object)rightPath)).isDirectory()) {
            this.showDiffForDirectory(root, (FilePath)ObjectUtils.chooseNotNull((Object)leftPath, (Object)rightPath), leftHash, rightHash);
        } else {
            this.loadDiffAndShow(new ThrowableComputable<DiffRequest, VcsException>(){

                public DiffRequest compute() throws VcsException {
                    DiffContent leftDiffContent = GitLogDiffHandler.this.createDiffContent(root, leftPath, leftHash);
                    DiffContent rightDiffContent = GitLogDiffHandler.this.createDiffContent(root, rightPath, rightHash);
                    return new SimpleDiffRequest(DiffRequestFactoryImpl.getTitle((FilePath)leftPath, (FilePath)rightPath, (String)" -> "), leftDiffContent, rightDiffContent, leftHash.asString(), rightHash.asString());
                }
            }, request -> DiffManager.getInstance().showDiff(this.myProject, request), "Calculating Diff for " + ((FilePath)ObjectUtils.chooseNotNull((Object)rightPath, (Object)leftPath)).getName());
        }
    }

    public void showDiffWithLocal(final @NotNull VirtualFile root, final @Nullable FilePath revisionPath, final @NotNull Hash revisionHash, final @NotNull FilePath localPath) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogDiffHandler", "showDiffWithLocal"));
        }
        if (revisionHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionHash", "git4idea/log/GitLogDiffHandler", "showDiffWithLocal"));
        }
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "git4idea/log/GitLogDiffHandler", "showDiffWithLocal"));
        }
        if (localPath.isDirectory()) {
            this.showDiffForDirectory(root, localPath, revisionHash, null);
        } else {
            this.loadDiffAndShow(new ThrowableComputable<DiffRequest, VcsException>(){

                public DiffRequest compute() throws VcsException {
                    DiffContent leftDiffContent = GitLogDiffHandler.this.createDiffContent(root, revisionPath, revisionHash);
                    VirtualFile file = localPath.getVirtualFile();
                    LOG.assertTrue(file != null);
                    DiffContent rightDiffContent = GitLogDiffHandler.this.myDiffContentFactory.create(GitLogDiffHandler.this.myProject, file);
                    return new SimpleDiffRequest(DiffRequestFactoryImpl.getTitle((FilePath)revisionPath, (FilePath)localPath, (String)" -> "), leftDiffContent, rightDiffContent, revisionHash.asString(), "(Local)");
                }
            }, request -> DiffManager.getInstance().showDiff(this.myProject, request), "Calculating Diff for " + localPath.getName());
        }
    }

    private void showDiffForDirectory(@NotNull VirtualFile root, @NotNull FilePath directoryPath, @NotNull Hash leftRevision, @Nullable Hash rightRevision) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogDiffHandler", "showDiffForDirectory"));
        }
        if (directoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryPath", "git4idea/log/GitLogDiffHandler", "showDiffForDirectory"));
        }
        if (leftRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftRevision", "git4idea/log/GitLogDiffHandler", "showDiffForDirectory"));
        }
        this.loadDiffAndShow(() -> {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogDiffHandler", "lambda$showDiffForDirectory$2"));
            }
            if (leftRevision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftRevision", "git4idea/log/GitLogDiffHandler", "lambda$showDiffForDirectory$2"));
            }
            if (directoryPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryPath", "git4idea/log/GitLogDiffHandler", "lambda$showDiffForDirectory$2"));
            }
            return GitChangeUtils.getDiff(this.myProject, root, leftRevision.asString(), rightRevision == null ? null : rightRevision.asString(), Collections.singleton(directoryPath));
        }, diff -> {
            if (leftRevision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftRevision", "git4idea/log/GitLogDiffHandler", "lambda$showDiffForDirectory$3"));
            }
            if (directoryPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryPath", "git4idea/log/GitLogDiffHandler", "lambda$showDiffForDirectory$3"));
            }
            String dialogTitle = "Changes between " + leftRevision.asString() + " and " + (rightRevision == null ? "current revision" : rightRevision.asString()) + " in " + DiffRequestFactoryImpl.getTitle((FilePath)directoryPath, (FilePath)directoryPath, (String)" -> ");
            VcsDiffUtil.showChangesDialog((Project)this.myProject, (String)dialogTitle, (List)ContainerUtil.newArrayList((Iterable)diff));
        }, "Calculating Diff for " + directoryPath.getName());
    }

    private <T> void loadDiffAndShow(final @NotNull ThrowableComputable<T, VcsException> load, final @NotNull Consumer<T> show, final @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (load == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "load", "git4idea/log/GitLogDiffHandler", "loadDiffAndShow"));
        }
        if (show == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "show", "git4idea/log/GitLogDiffHandler", "loadDiffAndShow"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "git4idea/log/GitLogDiffHandler", "loadDiffAndShow"));
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title + "...", false){
                @Nullable
                private T myResult;

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/log/GitLogDiffHandler$3", "run"));
                    }
                    try {
                        this.myResult = load.compute();
                    }
                    catch (VcsException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onSuccess() {
                    if (this.myResult != null) {
                        show.consume(this.myResult);
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "git4idea/log/GitLogDiffHandler$3", "onThrowable"));
                    }
                    VcsBalloonProblemNotifier.showOverVersionControlView((Project)this.myProject, (String)(title + " failed\n" + error.getMessage()), (MessageType)MessageType.ERROR);
                }
            });
        } else {
            try {
                Object result2 = load.compute();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (show == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "show", "git4idea/log/GitLogDiffHandler", "lambda$loadDiffAndShow$4"));
                    }
                    show.consume(result2);
                });
            }
            catch (VcsException e) {
                VcsBalloonProblemNotifier.showOverVersionControlView((Project)this.myProject, (String)(title + " failed\n" + e.getMessage()), (MessageType)MessageType.ERROR);
            }
        }
    }

    @NotNull
    private DiffContent createDiffContent(@NotNull VirtualFile root, @Nullable FilePath path, @NotNull Hash hash) throws VcsException {
        EmptyContent diffContent;
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/log/GitLogDiffHandler", "createDiffContent"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/log/GitLogDiffHandler", "createDiffContent"));
        }
        if (path == null) {
            diffContent = new EmptyContent();
        } else {
            try {
                byte[] content = GitFileUtils.getFileContent(this.myProject, root, hash.asString(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)path));
                diffContent = this.myDiffContentFactory.createFromBytes(this.myProject, content, path);
            }
            catch (IOException e) {
                throw new VcsException((Throwable)e);
            }
        }
        diffContent.putUserData(DiffUserDataKeysEx.REVISION_INFO, (Object)new Pair((Object)path, (Object)new GitRevisionNumber(hash.asString())));
        EmptyContent emptyContent = diffContent;
        if (emptyContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/log/GitLogDiffHandler", "createDiffContent"));
        }
        return emptyContent;
    }
}

