/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.cli;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import org.jetbrains.annotations.NotNull;

public class AngularJSProjectConfigurator
implements DirectoryProjectConfigurator {
    public static final String ANGULAR_CLI_JSON = ".angular-cli.json";

    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "org/angularjs/cli/AngularJSProjectConfigurator", "configureProject"));
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Module[] modules = moduleManager.getModules();
        if (modules.length == 1) {
            VirtualFile cliJson = baseDir.findChild(ANGULAR_CLI_JSON);
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)modules[0]).getModifiableModel();
            ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)baseDir);
            if (entry != null && cliJson != null) {
                AngularJSProjectConfigurator.excludeDefault(baseDir, entry);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    model.commit();
                    project.save();
                });
            } else {
                model.dispose();
            }
        }
    }

    public static void excludeDefault(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "org/angularjs/cli/AngularJSProjectConfigurator", "excludeDefault"));
        }
        entry.addExcludeFolder(baseDir.getUrl() + "/dist");
        entry.addExcludeFolder(baseDir.getUrl() + "/tmp");
    }
}

