/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlToken;
import java.util.Collection;
import org.angularjs.codeInsight.AngularJavaScriptCompletionContributor;
import org.angularjs.codeInsight.refs.AngularJSReferencesContributor;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularModuleIndex;
import org.angularjs.index.AngularUiRouterStatesIndex;
import org.jetbrains.annotations.NotNull;

public class AngularJSXmlCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/angularjs/codeInsight/AngularJSXmlCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/angularjs/codeInsight/AngularJSXmlCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement originalPosition = parameters.getOriginalPosition();
        if (originalPosition != null && AngularIndexUtil.hasAngularJS(originalPosition.getProject())) {
            PsiElement position;
            PsiElement psiElement = position = originalPosition instanceof XmlToken ? originalPosition.getParent() : originalPosition;
            if (AngularJSReferencesContributor.NG_APP_REF.accepts((Object)position)) {
                Collection<String> keys = AngularIndexUtil.getAllKeys(AngularModuleIndex.KEY, originalPosition.getProject());
                AngularJavaScriptCompletionContributor.addCompletionVariants(result, keys, " (AngularJS module)");
                result.stopHere();
            } else if (AngularJSReferencesContributor.UI_VIEW_REF.accepts((Object)position)) {
                Collection<String> keys = AngularIndexUtil.getAllKeys(AngularUiRouterStatesIndex.KEY, originalPosition.getProject());
                AngularJavaScriptCompletionContributor.addCompletionVariants(result, keys, " (angular-ui-router state)");
                result.stopHere();
            }
        }
    }
}

