/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.attributes;

import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.XmlAttributeDescriptor;
import org.angularjs.codeInsight.attributes.AngularAttributeDescriptor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularBindingDescriptor
extends AngularAttributeDescriptor {
    public static final JSType STRING_TYPE = new JSStringType(true, JSTypeSource.EXPLICITLY_DECLARED, JSTypeContext.INSTANCE);
    public static final String INPUT = "Input";
    public static final NotNullFunction<Pair<PsiElement, String>, XmlAttributeDescriptor> FACTORY = AngularBindingDescriptor::createBinding;
    public static final NullableFunction<Pair<PsiElement, String>, XmlAttributeDescriptor> FACTORY2 = AngularBindingDescriptor::createOneTimeBinding;

    public AngularBindingDescriptor(PsiElement element, String attributeName) {
        super(element.getProject(), attributeName, null, element);
    }

    public static XmlAttributeDescriptor[] getBindingDescriptors(JSImplicitElement declaration) {
        return (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])AngularBindingDescriptor.getFieldBasedDescriptors(declaration, INPUT, FACTORY), (Object[])AngularBindingDescriptor.getFieldBasedDescriptors(declaration, INPUT, FACTORY2));
    }

    @NotNull
    private static AngularBindingDescriptor createBinding(Pair<PsiElement, String> dom) {
        AngularBindingDescriptor angularBindingDescriptor = new AngularBindingDescriptor((PsiElement)dom.first, "[" + (String)dom.second + "]");
        if (angularBindingDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/attributes/AngularBindingDescriptor", "createBinding"));
        }
        return angularBindingDescriptor;
    }

    @Nullable
    private static AngularBindingDescriptor createOneTimeBinding(Pair<PsiElement, String> dom) {
        String type;
        PsiElement element = (PsiElement)dom.first;
        if (element instanceof JSImplicitElement && (type = ((JSImplicitElement)element).getTypeString()) != null && (type.endsWith("String") || type.endsWith("Object"))) {
            return new AngularBindingDescriptor(element, (String)dom.second);
        }
        type = AngularBindingDescriptor.expandStringLiteralTypes((JSType)(element instanceof JSFunction ? ((JSFunction)element).getReturnType() : (element instanceof JSField ? ((JSField)element).getType() : null)));
        return type != null && type.isDirectlyAssignableType(STRING_TYPE, null) ? new AngularBindingDescriptor(element, (String)dom.second) : null;
    }

    @Contract(value="null->null")
    private static JSType expandStringLiteralTypes(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        type = JSTypeUtils.getValuableType((JSType)type);
        final ProcessingContext context = new ProcessingContext();
        Function<JSType, JSType> expander = new Function<JSType, JSType>(){

            public JSType fun(@NotNull JSType toApply) {
                JSType typedef;
                if (toApply == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toApply", "org/angularjs/codeInsight/attributes/AngularBindingDescriptor$1", "fun"));
                }
                if (toApply instanceof JSStringLiteralTypeImpl) {
                    return STRING_TYPE;
                }
                if (toApply instanceof JSTypeImpl && (typedef = ((JSTypeImpl)toApply).getTypedef(null, context)) != null && toApply != typedef) {
                    return typedef.transformTypeHierarchy((Function)this);
                }
                return toApply;
            }
        };
        return type.transformTypeHierarchy((Function)expander);
    }

    @Override
    @Nullable
    public String handleTargetRename(@NotNull @NonNls String newTargetName) {
        if (newTargetName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTargetName", "org/angularjs/codeInsight/attributes/AngularBindingDescriptor", "handleTargetRename"));
        }
        return "[" + newTargetName + "]";
    }
}

