/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.attributes;

import com.intellij.lang.javascript.modules.diagramm.JSModuleConnectionProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IdFilter;
import icons.AngularJSIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularModuleIndex;
import org.jetbrains.annotations.NotNull;

public class AngularModulesProvider
implements JSModuleConnectionProvider {
    public static final Color ANGULAR_COLOR = new Color(221, 27, 22);

    public Color getEdgeColor() {
        return ANGULAR_COLOR;
    }

    public String getName() {
        return "AngularJS";
    }

    public List<JSModuleConnectionProvider.Link> getDependencies(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/angularjs/codeInsight/attributes/AngularModulesProvider", "getDependencies"));
        }
        Project project = file.getProject();
        if (!AngularIndexUtil.hasAngularJS(project)) {
            return null;
        }
        if (!(file instanceof JSFile)) {
            return null;
        }
        SmartPointerManager spm = SmartPointerManager.getInstance((Project)project);
        ArrayList<JSModuleConnectionProvider.Link> result = new ArrayList<JSModuleConnectionProvider.Link>();
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)file);
        final int fileId = FileBasedIndex.getFileId((VirtualFile)file.getVirtualFile());
        StubIndex.getInstance().processAllKeys(AngularModuleIndex.KEY, (Processor)processor, fileScope, new IdFilter(){

            public boolean containsFileId(int id) {
                return id == fileId;
            }
        });
        for (String key : processor.getResults()) {
            AngularIndexUtil.multiResolve(project, AngularModuleIndex.KEY, key, (Processor<JSImplicitElement>)((Processor)element -> {
                List<String> dependencies;
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/angularjs/codeInsight/attributes/AngularModulesProvider", "lambda$getDependencies$0"));
                }
                if (!file.equals(element.getContainingFile())) {
                    return true;
                }
                JSCallExpression expression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSCallExpression.class);
                if (expression != null && (dependencies = AngularModuleIndex.findDependenciesInModuleDeclaration(expression)) != null) {
                    for (String dependency : dependencies) {
                        JSImplicitElement resolve = AngularIndexUtil.resolve(project, AngularModuleIndex.KEY, dependency);
                        if (resolve == null) continue;
                        result.add(new JSModuleConnectionProvider.Link(spm.createSmartPsiElementPointer(element.getNavigationElement()), spm.createSmartPsiElementPointer(resolve.getNavigationElement()), key, resolve.getName(), AngularJSIcons.AngularJS));
                    }
                }
                return true;
            }));
        }
        return result;
    }
}

