/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight.refs;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.angularjs.codeInsight.refs.AngularPolyReferenceBase;
import org.angularjs.index.AngularIndexUtil;
import org.angularjs.index.AngularModuleIndex;
import org.jetbrains.annotations.NotNull;

public class AngularJSNgAppReferencesProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angularjs/codeInsight/refs/AngularJSNgAppReferencesProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/angularjs/codeInsight/refs/AngularJSNgAppReferencesProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new AngularJSNgAppReference((XmlAttributeValue)element)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSNgAppReferencesProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class AngularJSNgAppReference
    extends AngularPolyReferenceBase<XmlAttributeValue> {
        public AngularJSNgAppReference(XmlAttributeValue element) {
            super(element, ElementManipulators.getValueTextRange((PsiElement)element));
        }

        private String getAppName() {
            return StringUtil.unquoteString((String)this.getCanonicalText());
        }

        @Override
        @NotNull
        protected ResolveResult[] resolveInner() {
            String appName = this.getAppName();
            if (StringUtil.isEmptyOrSpaces((String)appName)) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSNgAppReferencesProvider$AngularJSNgAppReference", "resolveInner"));
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
            AngularIndexUtil.multiResolve(((XmlAttributeValue)this.getElement()).getProject(), AngularModuleIndex.KEY, appName, (Processor<JSImplicitElement>)collectProcessor);
            Collection results = collectProcessor.getResults();
            if (results.size() > 1) {
                Condition<JSImplicitElement> filter = new Condition<JSImplicitElement>(){
                    private Set<VirtualFile> includedFiles;

                    public boolean value(JSImplicitElement element) {
                        if (this.includedFiles == null) {
                            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)((XmlAttributeValue)this.getElement()).getProject()).getTopLevelFile((PsiElement)((XmlAttributeValue)this.getElement()).getContainingFile());
                            VirtualFile appDefinitionFile = topLevelFile.getVirtualFile();
                            VirtualFile[] includedFilesArr = FileIncludeManager.getManager((Project)((XmlAttributeValue)this.getElement()).getProject()).getIncludedFiles(appDefinitionFile, true, true);
                            this.includedFiles = new HashSet<VirtualFile>(Arrays.asList(includedFilesArr));
                        }
                        return this.includedFiles.contains(element.getContainingFile().getVirtualFile());
                    }
                };
                results = ContainerUtil.filter((Collection)results, (Condition)filter);
            }
            List resolveResults = ContainerUtil.map((Collection)results, AngularIndexUtil.JS_IMPLICIT_TO_RESOLVE_RESULT);
            ResolveResult[] resolveResultArray = resolveResults.toArray(ResolveResult.EMPTY_ARRAY);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSNgAppReferencesProvider$AngularJSNgAppReference", "resolveInner"));
            }
            return resolveResultArray;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/angularjs/codeInsight/refs/AngularJSNgAppReferencesProvider$AngularJSNgAppReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

