/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.angularjs.editor.AngularJSBracesUtil;

public class AngularBracesInterpolationTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (file.getViewProvider() instanceof MultiplePsiFilesPerDocumentFileViewProvider || DumbService.isDumb((Project)project)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return TypedHandlerDelegate.Result.DEFAULT;
        }
        if (file.getFileType() == HtmlFileType.INSTANCE) {
            Document document = editor.getDocument();
            if (c == '{') {
                if (!"{{".equals(AngularJSBracesUtil.getInjectionStart(project)) || !"}}".equals(AngularJSBracesUtil.getInjectionEnd(project))) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                JSCodeStyleSettings jsSettings = JSCodeStyleSettings.getSettings((PsiElement)file);
                boolean addWhiteSpaceBetweenBraces = jsSettings.SPACES_WITHIN_INTERPOLATION_EXPRESSIONS;
                int offset = editor.getCaretModel().getOffset();
                String chars = document.getText();
                if (offset > 0 && chars.charAt(offset - 1) == '{' && (offset < 2 || chars.charAt(offset - 2) != '{')) {
                    String interpolation;
                    if (AngularBracesInterpolationTypedHandler.alreadyHasEnding(chars, offset)) {
                        return TypedHandlerDelegate.Result.CONTINUE;
                    }
                    String string = interpolation = addWhiteSpaceBetweenBraces ? "{  }" : "{}";
                    if (offset == chars.length() || offset < chars.length() && chars.charAt(offset) != '}') {
                        interpolation = interpolation + "}";
                    }
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)interpolation, (boolean)true, (int)(addWhiteSpaceBetweenBraces ? 2 : 1));
                    return TypedHandlerDelegate.Result.STOP;
                }
            }
            if (c == '}') {
                char charAt;
                if (!"}}".equals(AngularJSBracesUtil.getInjectionEnd(project))) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                int offset = editor.getCaretModel().getOffset();
                if (offset < document.getTextLength()) {
                    charAt = document.getCharsSequence().charAt(offset);
                    if (charAt == '}') {
                        editor.getCaretModel().moveCaretRelatively(1, 0, false, false, true);
                        return TypedHandlerDelegate.Result.STOP;
                    }
                } else if (offset > 0 && (charAt = document.getCharsSequence().charAt(offset - 1)) != '}') {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"}}", (boolean)true, (int)2);
                    return TypedHandlerDelegate.Result.STOP;
                }
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean alreadyHasEnding(String chars, int offset) {
        int i;
        for (i = offset; i < chars.length() && chars.charAt(i) != '{' && chars.charAt(i) != '}' && chars.charAt(i) != '\n'; ++i) {
        }
        return i + 1 < chars.length() && chars.charAt(i) == '}' && chars.charAt(i + 1) == '}';
    }
}

