/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.properties.IntroComponentProperty;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public class NoLabelForInspection
extends BaseFormInspection {
    public NoLabelForInspection() {
        super("NoLabelFor");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = UIDesignerBundle.message("inspection.no.label.for", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/inspections/NoLabelForInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected void checkComponentProperties(Module module, @NotNull IComponent component, FormErrorCollector collector) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/inspections/NoLabelForInspection", "checkComponentProperties"));
        }
        ComponentItem item = Palette.getInstance(module.getProject()).getItem(component.getComponentClassName());
        if (item != null && item.isCanAttachLabel()) {
            IComponent root = component;
            while (root.getParentContainer() != null) {
                root = root.getParentContainer();
            }
            Ref found = new Ref((Object)Boolean.FALSE);
            Ref candidateLabel = new Ref();
            ArrayList<Object> allLabels = new ArrayList<Object>();
            FormEditingUtil.iterate(root, c2 -> {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/uiDesigner/inspections/NoLabelForInspection", "lambda$checkComponentProperties$0"));
                }
                if (FormInspectionUtil.isComponentClass(module, c2, JLabel.class)) {
                    IProperty prop = FormInspectionUtil.findProperty(c2, "labelFor");
                    if (prop != null && component.getId().equals(prop.getPropertyValue(c2))) {
                        found.set((Object)Boolean.TRUE);
                        return false;
                    }
                    if (component instanceof RadComponent && (prop == null || StringUtil.isEmpty((String)((String)prop.getPropertyValue(c2))))) {
                        RadComponent radComponent = (RadComponent)component;
                        RadComponent radComponent2 = (RadComponent)c2;
                        allLabels.add(radComponent2);
                        if (radComponent.getParent() == radComponent2.getParent() && radComponent.getParent().getLayoutManager().isGrid()) {
                            GridConstraints gc1 = radComponent.getConstraints();
                            GridConstraints gc2 = radComponent2.getConstraints();
                            int nextColumn = FormEditingUtil.nextCol(radComponent.getParent(), gc2.getColumn());
                            int nextRow = FormEditingUtil.nextRow(radComponent.getParent(), gc2.getRow());
                            if (gc1.getRow() == gc2.getRow() && nextColumn == gc1.getColumn() || gc1.getColumn() == gc2.getColumn() && nextRow == gc1.getRow()) {
                                candidateLabel.set((Object)radComponent2);
                            }
                        }
                    }
                }
                return true;
            });
            if (!((Boolean)found.get()).booleanValue()) {
                if (!candidateLabel.isNull()) {
                    allLabels.clear();
                    allLabels.add(candidateLabel.get());
                }
                EditorQuickFixProvider[] quickFixProviders = new EditorQuickFixProvider[allLabels.size()];
                for (int i = 0; i < quickFixProviders.length; ++i) {
                    RadComponent label = (RadComponent)allLabels.get(i);
                    quickFixProviders[i] = (editor, component1) -> new MyQuickFix(editor, component1, label);
                }
                collector.addError(this.getID(), component, null, UIDesignerBundle.message("inspection.no.label.for.error", new Object[0]), quickFixProviders);
            }
        }
    }

    private static class MyQuickFix
    extends QuickFix {
        private final RadComponent myLabel;

        MyQuickFix(GuiEditor editor, RadComponent component, RadComponent label) {
            super(editor, UIDesignerBundle.message("inspection.no.label.for.quickfix", label.getComponentTitle()), component);
            this.myLabel = label;
        }

        @Override
        public void run() {
            if (!this.myEditor.ensureEditable()) {
                return;
            }
            Runnable runnable = () -> {
                Palette palette = Palette.getInstance(this.myEditor.getProject());
                IntrospectedProperty[] props = palette.getIntrospectedProperties(this.myLabel);
                boolean modified = false;
                for (IntrospectedProperty prop : props) {
                    if (!prop.getName().equals("labelFor") || !(prop instanceof IntroComponentProperty)) continue;
                    IntroComponentProperty icp = (IntroComponentProperty)prop;
                    icp.setValueEx(this.myLabel, this.myComponent.getId());
                    modified = true;
                    break;
                }
                if (modified) {
                    this.myEditor.refreshAndSave(false);
                }
            };
            CommandProcessor.getInstance().executeCommand(this.myEditor.getProject(), runnable, UIDesignerBundle.message("inspection.no.label.for.command", new Object[0]), null);
        }
    }
}

