/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors.string;

import com.intellij.CommonBundle;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.ide.util.TreeFileChooser;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.PropertiesUtilBase;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.StringDescriptorManager;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.binding.FormReferenceProvider;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.editors.string.KeyChooserDialog;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringEditorDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.propertyInspector.editors.string.StringEditorDialog");
    @NonNls
    private static final String CARD_STRING = "string";
    @NonNls
    private static final String CARD_BUNDLE = "bundle";
    private final GuiEditor myEditor;
    private StringDescriptor myValue;
    private final MyForm myForm;
    private final Locale myLocale;
    private boolean myDefaultBundleInitialized = false;

    StringEditorDialog(Component parent, StringDescriptor descriptor, @Nullable Locale locale, GuiEditor editor) {
        super(parent, true);
        this.myLocale = locale;
        this.myEditor = editor;
        this.myForm = new MyForm();
        this.setTitle(UIDesignerBundle.message("title.edit.text", new Object[0]));
        this.setValue(descriptor);
        this.init();
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myForm.myRbString.isSelected()) {
            return this.myForm.myTfValue;
        }
        return super.getPreferredFocusedComponent();
    }

    protected void doOKAction() {
        StringDescriptor descriptor;
        if (this.myForm.myRbResourceBundle.isSelected() && (descriptor = this.getDescriptor()) != null && descriptor.getKey().length() > 0) {
            String value = this.myForm.myTfRbValue.getText();
            PropertiesFile propFile = this.getPropertiesFile(descriptor);
            if (propFile != null && propFile.findPropertyByKey(descriptor.getKey()) == null) {
                StringEditorDialog.saveCreatedProperty(propFile, descriptor.getKey(), value, this.myEditor.getPsiFile());
            } else {
                String newKeyName = StringEditorDialog.saveModifiedPropertyValue(this.myEditor.getModule(), descriptor, this.myLocale, value, this.myEditor.getPsiFile());
                if (newKeyName != null) {
                    this.myForm.myTfKey.setText(newKeyName);
                }
            }
        }
        super.doOKAction();
    }

    private PropertiesFile getPropertiesFile(StringDescriptor descriptor) {
        PropertiesReferenceManager manager = PropertiesReferenceManager.getInstance((Project)this.myEditor.getProject());
        return manager.findPropertiesFile(this.myEditor.getModule(), descriptor.getDottedBundleName(), this.myLocale);
    }

    @Nullable
    public static String saveModifiedPropertyValue(Module module, StringDescriptor descriptor, Locale locale, String editedValue, PsiFile formFile) {
        IProperty propertyByKey;
        PropertiesReferenceManager manager = PropertiesReferenceManager.getInstance((Project)module.getProject());
        PropertiesFile propFile = manager.findPropertiesFile(module, descriptor.getDottedBundleName(), locale);
        if (propFile != null && (propertyByKey = propFile.findPropertyByKey(descriptor.getKey())) instanceof Property && !editedValue.equals(propertyByKey.getValue())) {
            ReadonlyStatusHandler.OperationStatus operationStatus;
            Collection<PsiReference> references = StringEditorDialog.findPropertyReferences((Property)propertyByKey, module);
            String newKeyName = null;
            if (references.size() > 1) {
                int rc = Messages.showYesNoCancelDialog((Project)module.getProject(), (String)UIDesignerBundle.message("edit.text.multiple.usages", propertyByKey.getUnescapedKey(), references.size()), (String)UIDesignerBundle.message("edit.text.multiple.usages.title", new Object[0]), (String)UIDesignerBundle.message("edit.text.change.all", new Object[0]), (String)UIDesignerBundle.message("edit.text.make.unique", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
                if (rc == 2) {
                    return null;
                }
                if (rc == 1 && (newKeyName = StringEditorDialog.promptNewKeyName(module.getProject(), propFile, descriptor.getKey())) == null) {
                    return null;
                }
            }
            if ((operationStatus = ReadonlyStatusHandler.getInstance((Project)module.getProject()).ensureFilesWritable(new VirtualFile[]{propFile.getVirtualFile()})).hasReadonlyFiles()) {
                return null;
            }
            String newKeyName1 = newKeyName;
            CommandProcessor.getInstance().executeCommand(module.getProject(), () -> {
                UndoUtil.markPsiFileForUndo((PsiFile)formFile);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiDocumentManager.getInstance((Project)module.getProject()).commitAllDocuments();
                    try {
                        if (newKeyName1 != null) {
                            propFile.addProperty(newKeyName1, editedValue);
                        } else {
                            IProperty propertyByKey1 = propFile.findPropertyByKey(descriptor.getKey());
                            if (propertyByKey1 != null) {
                                propertyByKey1.setValue(editedValue);
                            }
                        }
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                });
            }, UIDesignerBundle.message("command.update.property", new Object[0]), null);
            return newKeyName;
        }
        return null;
    }

    private static Collection<PsiReference> findPropertyReferences(Property property, Module module) {
        List<PsiReference> references = Collections.synchronizedList(new ArrayList());
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReferencesSearch.search((PsiElement)property).forEach(psiReference -> {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethod.class);
            if (method == null || !"$$$setupUI$$$".equals(method.getName())) {
                references.add((PsiReference)psiReference);
            }
            return true;
        }), UIDesignerBundle.message("edit.text.searching.references", new Object[0]), false, module.getProject());
        return references;
    }

    private static String promptNewKeyName(Project project, final PropertiesFile propFile, String key) {
        String newName;
        int index = 0;
        while (propFile.findPropertyByKey(newName = key + ++index) != null) {
        }
        InputValidator validator = new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString.length() > 0 && propFile.findPropertyByKey(inputString) == null;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        };
        return Messages.showInputDialog((Project)project, (String)UIDesignerBundle.message("edit.text.unique.key.prompt", new Object[0]), (String)UIDesignerBundle.message("edit.text.multiple.usages.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)newName, (InputValidator)validator);
    }

    public static boolean saveCreatedProperty(PropertiesFile bundle, String name, String value, PsiFile formFile) {
        ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)bundle.getProject()).ensureFilesWritable(new VirtualFile[]{bundle.getVirtualFile()});
        if (operationStatus.hasReadonlyFiles()) {
            return false;
        }
        CommandProcessor.getInstance().executeCommand(bundle.getProject(), () -> {
            UndoUtil.markPsiFileForUndo((PsiFile)formFile);
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    bundle.addProperty(name, value);
                }
                catch (IncorrectOperationException e1) {
                    LOG.error((Throwable)e1);
                }
            });
        }, UIDesignerBundle.message("command.create.property", new Object[0]), null);
        return true;
    }

    @Nullable
    StringDescriptor getDescriptor() {
        if (this.myForm.myRbString.isSelected()) {
            String value = this.myForm.myTfValue.getText();
            if (this.myValue == null && value.length() == 0) {
                return null;
            }
            StringDescriptor stringDescriptor = StringDescriptor.create((String)value);
            stringDescriptor.setNoI18n(this.myForm.myNoI18nCheckbox.isSelected());
            return stringDescriptor;
        }
        String bundleName = this.myForm.myTfBundleName.getText();
        String key = this.myForm.myTfKey.getText();
        return new StringDescriptor(bundleName, key);
    }

    private void setValue(StringDescriptor descriptor) {
        this.myValue = descriptor;
        CardLayout cardLayout = (CardLayout)this.myForm.myCardHolder.getLayout();
        if (descriptor == null || descriptor.getValue() != null) {
            this.myForm.myRbString.setSelected(true);
            this.myForm.showStringDescriptor(descriptor);
            cardLayout.show(this.myForm.myCardHolder, CARD_STRING);
        } else {
            this.myForm.myRbResourceBundle.setSelected(true);
            this.myForm.showResourceBundleDescriptor(descriptor);
            cardLayout.show(this.myForm.myCardHolder, CARD_BUNDLE);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myForm.myPanel;
    }

    private final class MyForm {
        private JRadioButton myRbString;
        private JRadioButton myRbResourceBundle;
        private JPanel myCardHolder;
        private JPanel myPanel;
        private JTextArea myTfValue;
        private JCheckBox myNoI18nCheckbox;
        private TextFieldWithBrowseButton myTfBundleName;
        private TextFieldWithBrowseButton myTfKey;
        private JTextField myTfRbValue;
        private JLabel myLblKey;
        private JLabel myLblBundleName;

        public MyForm() {
            this.$$$setupUI$$$();
            this.myRbString.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CardLayout cardLayout = (CardLayout)MyForm.this.myCardHolder.getLayout();
                    cardLayout.show(MyForm.this.myCardHolder, StringEditorDialog.CARD_STRING);
                }
            });
            this.myRbResourceBundle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!StringEditorDialog.this.myDefaultBundleInitialized) {
                        StringEditorDialog.this.myDefaultBundleInitialized = true;
                        Set<String> bundleNames = FormEditingUtil.collectUsedBundleNames(StringEditorDialog.this.myEditor.getRootContainer());
                        if (bundleNames.size() > 0) {
                            MyForm.this.myTfBundleName.setText(ArrayUtil.toStringArray(bundleNames)[0]);
                        }
                    }
                    CardLayout cardLayout = (CardLayout)MyForm.this.myCardHolder.getLayout();
                    cardLayout.show(MyForm.this.myCardHolder, StringEditorDialog.CARD_BUNDLE);
                }
            });
            this.setupResourceBundleCard();
        }

        private void setupResourceBundleCard() {
            this.myTfBundleName.registerKeyboardAction((ActionListener)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyForm.this.myTfBundleName.getButton().doClick();
                }
            }, KeyStroke.getKeyStroke(this.myLblBundleName.getDisplayedMnemonic(), 512), 2);
            this.myTfBundleName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Project project = StringEditorDialog.this.myEditor.getProject();
                    String bundleNameText = MyForm.this.myTfBundleName.getText().replace('/', '.');
                    PropertiesFile file = PropertiesUtilBase.getPropertiesFile((String)bundleNameText, (Module)StringEditorDialog.this.myEditor.getModule(), (Locale)StringEditorDialog.this.myLocale);
                    PsiFile initialPropertiesFile = file == null ? null : file.getContainingFile();
                    final GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesScope((Module)StringEditorDialog.this.myEditor.getModule());
                    TreeFileChooser fileChooser = TreeClassChooserFactory.getInstance((Project)project).createFileChooser(UIDesignerBundle.message("title.choose.properties.file", new Object[0]), initialPropertiesFile, (FileType)StdFileTypes.PROPERTIES, new TreeFileChooser.PsiFileFilter(){

                        public boolean accept(PsiFile file) {
                            VirtualFile virtualFile = file.getVirtualFile();
                            return virtualFile != null && moduleScope.contains(virtualFile);
                        }
                    });
                    fileChooser.showDialog();
                    PropertiesFile propertiesFile = (PropertiesFile)fileChooser.getSelectedFile();
                    if (propertiesFile == null) {
                        return;
                    }
                    String bundleName = FormReferenceProvider.getBundleName(propertiesFile);
                    if (bundleName == null) {
                        return;
                    }
                    MyForm.this.myTfBundleName.setText(bundleName);
                }
            });
            this.myTfKey.registerKeyboardAction((ActionListener)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MyForm.this.myTfKey.getButton().doClick();
                }
            }, KeyStroke.getKeyStroke(this.myLblKey.getDisplayedMnemonic(), 512), 2);
            this.myTfKey.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String bundleName = MyForm.this.myTfBundleName.getText();
                    if (bundleName.length() == 0) {
                        Messages.showErrorDialog((String)UIDesignerBundle.message("error.specify.bundle.name", new Object[0]), (String)CommonBundle.getErrorTitle());
                        return;
                    }
                    PropertiesReferenceManager manager = PropertiesReferenceManager.getInstance((Project)StringEditorDialog.this.myEditor.getProject());
                    PropertiesFile bundle = manager.findPropertiesFile(StringEditorDialog.this.myEditor.getModule(), bundleName.replace('/', '.'), StringEditorDialog.this.myLocale);
                    if (bundle == null) {
                        Messages.showErrorDialog((String)UIDesignerBundle.message("error.bundle.does.not.exist", bundleName), (String)CommonBundle.getErrorTitle());
                        return;
                    }
                    KeyChooserDialog dialog = new KeyChooserDialog((Component)MyForm.this.myTfKey, bundle, bundleName, MyForm.this.myTfKey.getText(), StringEditorDialog.this.myEditor);
                    if (!dialog.showAndGet()) {
                        return;
                    }
                    StringDescriptor descriptor = dialog.getDescriptor();
                    if (descriptor == null) {
                        return;
                    }
                    MyForm.this.myTfKey.setText(descriptor.getKey());
                    MyForm.this.myTfRbValue.setText(descriptor.getResolvedValue());
                }
            });
        }

        public void showStringDescriptor(@Nullable StringDescriptor descriptor) {
            this.myTfValue.setText(StringDescriptorManager.getInstance(StringEditorDialog.this.myEditor.getModule()).resolve(descriptor, StringEditorDialog.this.myLocale));
            this.myNoI18nCheckbox.setSelected(descriptor != null && descriptor.isNoI18n());
        }

        public void showResourceBundleDescriptor(@NotNull StringDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/uiDesigner/propertyInspector/editors/string/StringEditorDialog$MyForm", "showResourceBundleDescriptor"));
            }
            String key = descriptor.getKey();
            LOG.assertTrue(key != null);
            this.myTfBundleName.setText(descriptor.getBundleName());
            this.myTfKey.setText(key);
            this.myTfRbValue.setText(StringDescriptorManager.getInstance(StringEditorDialog.this.myEditor.getModule()).resolve(descriptor, StringEditorDialog.this.myLocale));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            TextFieldWithBrowseButton textFieldWithBrowseButton2;
            JTextField jTextField;
            JLabel jLabel;
            JLabel jLabel2;
            JTextArea jTextArea;
            JCheckBox jCheckBox;
            JPanel jPanel;
            JRadioButton jRadioButton;
            JRadioButton jRadioButton2;
            JPanel jPanel2;
            this.myPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myRbString = jRadioButton2 = new JRadioButton();
            jRadioButton2.setMargin(new Insets(2, 0, 2, 2));
            this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("radio.string"));
            jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myRbResourceBundle = jRadioButton = new JRadioButton();
            jRadioButton.setMargin(new Insets(2, 0, 2, 2));
            this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("radio.resource.bundle"));
            jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myCardHolder = jPanel = new JPanel();
            jPanel.setLayout(new CardLayout(0, 0));
            jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel3, StringEditorDialog.CARD_STRING);
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("editbox.value.2"));
            jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myNoI18nCheckbox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("uidesigner.string.no.i18n"));
            jCheckBox.setSelected(false);
            jPanel3.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JBScrollPane jBScrollPane = new JBScrollPane();
            jPanel3.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
            this.myTfValue = jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jBScrollPane.setViewportView(jTextArea);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel4, StringEditorDialog.CARD_BUNDLE);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myLblKey = jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("editbox.key"));
            jPanel5.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel4 = new JLabel();
            this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("editbox.value"));
            jPanel5.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myLblBundleName = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("editbox.bundle.name"));
            jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myTfRbValue = jTextField = new JTextField();
            jTextField.setColumns(30);
            jPanel5.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, null, null));
            this.myTfKey = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
            textFieldWithBrowseButton2.setEnabled(true);
            textFieldWithBrowseButton2.setEditable(false);
            jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.myTfBundleName = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            textFieldWithBrowseButton.setEditable(false);
            jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            Spacer spacer = new Spacer();
            jPanel4.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            jLabel4.setLabelFor(jTextField);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton2);
            buttonGroup.add(jRadioButton);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

