/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model;

import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.ejb.EjbModuleUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.model.JavaeeResolvingConverter;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.openapi.project.Project;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbLinkResolveConverter
extends JavaeeResolvingConverter<EnterpriseBean> {
    public EnterpriseBean fromString(String s, ConvertContext context) {
        return EjbLinkResolveConverter.resolveEnterpriseBean(s, JavaeeFacetUtil.getInstance().getJavaeeFacet(context));
    }

    @Nullable
    public static EnterpriseBean resolveEnterpriseBean(String s, @Nullable JavaeeFacet contextFacet) {
        if (s == null || contextFacet == null) {
            return null;
        }
        int index = s.indexOf(35);
        Project project = contextFacet.getModule().getProject();
        if (index < 0) {
            EjbFacet facet = contextFacet instanceof EjbFacet ? (EjbFacet)contextFacet : null;
            EnterpriseBean ejb = (EnterpriseBean)ElementPresentationManager.findByName(EjbCommonModelUtil.getAllEjbs(project, contextFacet.getModule(), facet), (String)s);
            if (ejb != null) {
                return ejb;
            }
            return (EnterpriseBean)ElementPresentationManager.findByName(EjbCommonModelUtil.getAllEjbs(project), (String)s);
        }
        String relative = s.substring(0, index);
        for (EjbFacet ejbFacet : JavaeeFacetUtil.getInstance().getJavaeeFacets(EjbFacet.ID, project)) {
            if (!relative.equals(EjbLinkResolveConverter.getRelativePath(contextFacet, ejbFacet))) continue;
            return (EnterpriseBean)ElementPresentationManager.findByName(EjbCommonModelUtil.getAllEjbs(project, null, ejbFacet), (String)s.substring(index + 1));
        }
        return null;
    }

    @Nullable
    private static String getRelativePath(@Nullable JavaeeFacet contextFacet, @Nullable EjbFacet ejbFacet) {
        if (contextFacet == null || ejbFacet == null) {
            return null;
        }
        return JavaeeArtifactUtil.getInstance().getRelativePath(contextFacet, ejbFacet);
    }

    @Override
    public String toString(EnterpriseBean t, ConvertContext context) {
        if (t == null) {
            return null;
        }
        EjbFacet ejbFacet = EjbModuleUtil.getEjbFacet(t);
        JavaeeFacet contextFacet = JavaeeFacetUtil.getInstance().getJavaeeFacet(context);
        String ejbName = (String)t.getEjbName().getValue();
        if (ejbFacet == contextFacet) {
            return ejbName;
        }
        String relativePath = EjbLinkResolveConverter.getRelativePath(contextFacet, ejbFacet);
        return relativePath == null ? ejbName : relativePath + "#" + ejbName;
    }

    @NotNull
    public Collection<? extends EnterpriseBean> getVariants(ConvertContext context) {
        List<EnterpriseBean> list = EjbCommonModelUtil.getAllEjbs(context.getProject());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/EjbLinkResolveConverter", "getVariants"));
        }
        return list;
    }
}

