/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.remote.impl;

import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.jpa.remote.RemoteQueryResult;
import com.intellij.jpa.remote.impl.QueryResult;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;

public class RemoteQueryResultImpl
extends JdbcRemoteObject
implements RemoteQueryResult {
    private final QueryResult myDelegate;
    private final List<WeakReference<RemoteObject>> myExportedResults = ContainerUtil.createLockFreeCopyOnWriteList();

    protected RemoteQueryResultImpl(QueryResult delegate) {
        this.myDelegate = delegate;
    }

    public static RemoteQueryResultImpl wrap(QueryResult delegate) {
        return new RemoteQueryResultImpl(delegate);
    }

    private void dropExportedResults() throws RemoteException {
        this.unexportChildren(this.myExportedResults);
        this.myExportedResults.clear();
    }

    public <T extends Remote> T export2(T child) throws RemoteException {
        if (child == null) {
            return null;
        }
        this.myExportedResults.add(((JdbcRemoteObject)child).getWeakRef());
        return (T)this.export(child);
    }

    public synchronized void unexportChildren() throws RemoteException {
        this.myExportedResults.clear();
        super.unexportChildren();
    }

    @Override
    public Object getObject(int p1) throws RemoteException {
        try {
            return this.wrapIfNeeded(this.myDelegate.getObject(p1), null);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public boolean next() throws RemoteException {
        try {
            this.dropExportedResults();
            return this.myDelegate.next();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public int getSize() throws RemoteException {
        try {
            return this.myDelegate.getSize();
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }

    @Override
    public QueryResult.Column[] getColumnInfos(int start, int pageSize, String[] expectedColumns) throws RemoteException {
        try {
            return this.myDelegate.getColumnInfos(start, pageSize, expectedColumns);
        }
        catch (Exception e) {
            throw this.rethrowRuntimeException(e);
        }
    }
}

