/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.diagram;

import com.intellij.ProjectTopics;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.jboss.jbpm.diagram.beans.BpmnDiagramEdge;
import com.intellij.jboss.jbpm.diagram.beans.BpmnDiagramNode;
import com.intellij.jboss.jbpm.diagram.beans.BpmnEdgeType;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.Bpmn20DomElementWrapper;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnElementWrapper;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnUnknownNodeElementWrapper;
import com.intellij.jboss.jbpm.diagram.managers.BpmnNodeContentManager;
import com.intellij.jboss.jbpm.model.BpmnDomModel;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TBaseElement;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TDefinitions;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TFlowNode;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TProcess;
import com.intellij.jboss.jbpm.model.xml.bpmn20.TSequenceFlow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.events.DomEvent;
import gnu.trove.THashMap;
import icons.JbpmIcons;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BpmnDiagramDataModel
extends DiagramDataModel<BpmnElementWrapper> {
    public static final DiagramCategory SUB_FLOWS = new DiagramCategory("Sub Flows", JbpmIcons.Bpmn.SubProcess, true, true, true);
    private final Collection<DiagramNode<BpmnElementWrapper>> myNodes = new HashSet<DiagramNode<BpmnElementWrapper>>();
    private final Collection<DiagramEdge<BpmnElementWrapper>> myEdges = new HashSet<DiagramEdge<BpmnElementWrapper>>();
    private final BpmnElementWrapper<?> myRootElementWrapper;
    private final DiagramPresentationModel myPresentationModel;

    public BpmnDiagramDataModel(Project project, DiagramProvider<BpmnElementWrapper> provider, BpmnElementWrapper<?> rootElementWrapper, DiagramPresentationModel presentationModel) {
        super(project, provider);
        this.myRootElementWrapper = rootElementWrapper;
        this.myPresentationModel = presentationModel;
        this.setShowDependencies(true);
        DomManager.getDomManager((Project)project).addDomEventListener(new DomEventListener(){

            public void eventOccured(DomEvent event) {
                BpmnDiagramDataModel.this.incModificationCount();
            }
        }, (Disposable)this);
        MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
        connection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                BpmnDiagramDataModel.this.incModificationCount();
            }
        });
        connection.subscribe(ProjectTopics.PROJECT_ROOTS);
        connection.subscribe(ProjectTopics.MODULES);
    }

    public boolean isDependencyDiagramSupported() {
        return true;
    }

    public boolean isPsiListener() {
        return true;
    }

    public boolean hasFile(PsiFile file) {
        for (BpmnDomModel model : this.getProcessDefinitionModels()) {
            TDefinitions flow = model.getDefinitions();
            XmlFile xmlFile = DomUtil.getFile((DomElement)flow);
            if (!xmlFile.equals(file)) continue;
            return true;
        }
        return false;
    }

    public void removeNode(DiagramNode<BpmnElementWrapper> node) {
        this.myNodes.remove(node);
        SmartList toRemove = new SmartList();
        for (DiagramEdge<BpmnElementWrapper> edge : this.myEdges) {
            if (!edge.getSource().equals(node) && !edge.getTarget().equals(node)) continue;
            toRemove.add(edge);
        }
        this.myEdges.removeAll((Collection<?>)toRemove);
    }

    @NotNull
    public Collection<DiagramNode<BpmnElementWrapper>> getNodes() {
        Collection<DiagramNode<BpmnElementWrapper>> collection = this.myNodes;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/diagram/BpmnDiagramDataModel", "getNodes"));
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<BpmnElementWrapper>> getEdges() {
        Collection<DiagramEdge<BpmnElementWrapper>> collection = this.myEdges;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/diagram/BpmnDiagramDataModel", "getEdges"));
        }
        return collection;
    }

    @NotNull
    public String getNodeName(DiagramNode<BpmnElementWrapper> node) {
        String string = node.getTooltip();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/diagram/BpmnDiagramDataModel", "getNodeName"));
        }
        return string;
    }

    public DiagramNode<BpmnElementWrapper> addElement(BpmnElementWrapper element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        return null;
    }

    public DiagramEdge<BpmnElementWrapper> createEdge(@NotNull DiagramNode<BpmnElementWrapper> from, @NotNull DiagramNode<BpmnElementWrapper> to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/jboss/jbpm/diagram/BpmnDiagramDataModel", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/jboss/jbpm/diagram/BpmnDiagramDataModel", "createEdge"));
        }
        if (this.getBuilder().isPopupMode()) {
            return null;
        }
        DomElement fromDom = (DomElement)((Bpmn20DomElementWrapper)from.getIdentifyingElement()).getElement();
        DomElement toDom = (DomElement)((Bpmn20DomElementWrapper)to.getIdentifyingElement()).getElement();
        return super.createEdge(from, to);
    }

    public List<BpmnDomModel> getProcessDefinitionModels() {
        return this.myRootElementWrapper.getBpmnModels();
    }

    public void refreshDataModel() {
        this.myNodes.clear();
        this.myEdges.clear();
        this.updateDataModel();
    }

    private void updateDataModel() {
        DumbService.getInstance((Project)this.getProject()).runWhenSmart(() -> {
            if (this.getBuilder().isPopupMode()) {
                this.setShowDependencies(false);
                this.myPresentationModel.getPresentation().setCategoryEnabled(BpmnNodeContentManager.DETAILS, false);
            }
            for (BpmnDomModel model : this.getProcessDefinitionModels()) {
                this.processDefinitions(model.getDefinitions());
            }
        });
    }

    private void processDefinitions(TDefinitions definitions) {
        for (TProcess tProcess : definitions.getProcesses()) {
            this.processTProcess(tProcess);
        }
    }

    private void processTProcess(@NotNull TProcess process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/jboss/jbpm/diagram/BpmnDiagramDataModel", "processTProcess"));
        }
        List<TFlowNode> elements = process.getFlowNodes();
        THashMap nodes = new THashMap();
        for (TFlowNode element : elements) {
            String nodeId = element.getId().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)nodeId)) continue;
            nodes.put(nodeId, new BpmnDiagramNode(new Bpmn20DomElementWrapper(element), (DiagramProvider<BpmnElementWrapper>)this.getProvider()));
        }
        for (TSequenceFlow flow : process.getSequenceFlows()) {
            GenericAttributeValue<TBaseElement> sourceRef = flow.getSourceRef();
            GenericAttributeValue<TBaseElement> targetRef = flow.getTargetRef();
            String sourceId = sourceRef.getStringValue();
            String targetId = targetRef.getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)sourceId) || StringUtil.isEmptyOrSpaces((String)targetId)) continue;
            this.myEdges.add((DiagramEdge<BpmnElementWrapper>)new BpmnDiagramEdge((DiagramNode<BpmnElementWrapper>)this.getNodeById((Map<String, BpmnDiagramNode>)nodes, sourceId), (DiagramNode<BpmnElementWrapper>)this.getNodeById((Map<String, BpmnDiagramNode>)nodes, targetId), flow, BpmnEdgeType.FLOW));
        }
        this.myNodes.addAll(nodes.values());
    }

    @NotNull
    private BpmnDiagramNode getNodeById(@NotNull Map<String, BpmnDiagramNode> nodes, @NotNull String nodeId) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/jboss/jbpm/diagram/BpmnDiagramDataModel", "getNodeById"));
        }
        if (nodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeId", "com/intellij/jboss/jbpm/diagram/BpmnDiagramDataModel", "getNodeById"));
        }
        if (!nodes.containsKey(nodeId)) {
            nodes.put(nodeId, new BpmnDiagramNode(new BpmnUnknownNodeElementWrapper(nodeId), (DiagramProvider<BpmnElementWrapper>)this.getProvider()));
        }
        BpmnDiagramNode bpmnDiagramNode = nodes.get(nodeId);
        if (bpmnDiagramNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/diagram/BpmnDiagramDataModel", "getNodeById"));
        }
        return bpmnDiagramNode;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        BpmnDiagramDataModel bpmnDiagramDataModel = this;
        if (bpmnDiagramDataModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jbpm/diagram/BpmnDiagramDataModel", "getModificationTracker"));
        }
        return bpmnDiagramDataModel;
    }

    public void dispose() {
    }
}

