/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jpdl.utils;

import com.intellij.jboss.jpdl.model.JpdlDomModelManager;
import com.intellij.jboss.jpdl.model.JpdlModel;
import com.intellij.jboss.jpdl.model.xml.ProcessDefinition;
import com.intellij.openapi.module.Module;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpdlCommonUtils {
    @NotNull
    public static List<ProcessDefinition> getProcessDefinitions(@Nullable Module module) {
        if (module == null) {
            List<ProcessDefinition> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/utils/JpdlCommonUtils", "getProcessDefinitions"));
            }
            return list;
        }
        List<JpdlModel> models = JpdlDomModelManager.getInstance(module.getProject()).getAllModels(module);
        List list = ContainerUtil.map2List(models, processModel -> (ProcessDefinition)((DomFileElement)processModel.getRoots().get(0)).getRootElement());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/utils/JpdlCommonUtils", "getProcessDefinitions"));
        }
        return list;
    }

    @NotNull
    public static List<String> getProcessNames(@Nullable Module module) {
        List list = ContainerUtil.mapNotNull(JpdlCommonUtils.getProcessDefinitions(module), processDefinition -> processDefinition.getName().getStringValue());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jboss/jpdl/utils/JpdlCommonUtils", "getProcessNames"));
        }
        return list;
    }
}

