/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ActionHint {
    private final String myExpectedText;
    private final boolean myShouldPresent;
    private final ProblemHighlightType myHighlightType;

    private ActionHint(String expectedText, boolean shouldPresent, ProblemHighlightType severity) {
        this.myExpectedText = expectedText;
        this.myShouldPresent = shouldPresent;
        this.myHighlightType = severity;
    }

    public String getExpectedText() {
        return this.myExpectedText;
    }

    public boolean shouldPresent() {
        return this.myShouldPresent;
    }

    @Nullable
    public IntentionAction findAndCheck(Collection<IntentionAction> actions, Supplier<String> infoSupplier) {
        IntentionAction result = actions.stream().filter(t -> t.getText().equals(this.myExpectedText)).findFirst().orElse(null);
        if (this.myShouldPresent) {
            if (result == null) {
                Assert.fail((String)("Action with text '" + this.myExpectedText + "' not found\nAvailable actions: " + actions.stream().map(IntentionAction::getText).collect(Collectors.joining(", ", "[", "]\n")) + infoSupplier.get()));
            } else if (this.myHighlightType != null) {
                ProblemHighlightType actualType;
                if (result instanceof IntentionActionDelegate) {
                    result = ((IntentionActionDelegate)((Object)result)).getDelegate();
                }
                if (!(result instanceof QuickFixWrapper)) {
                    Assert.fail((String)("Action with text '" + this.myExpectedText + "' is not a LocalQuickFix, but " + result.getClass().getName() + "\nExpected LocalQuickFix with ProblemHighlightType=" + (Object)((Object)this.myHighlightType) + "\n" + infoSupplier.get()));
                }
                if ((actualType = ((QuickFixWrapper)result).getHighlightType()) != this.myHighlightType) {
                    Assert.fail((String)("Action with text '" + this.myExpectedText + "' has wrong ProblemHighlightType.\nExpected: " + (Object)((Object)this.myHighlightType) + "\nActual: " + (Object)((Object)actualType) + "\n" + infoSupplier.get()));
                }
            }
        } else if (result != null) {
            Assert.fail((String)("Action with text '" + this.myExpectedText + "' is present, but should not\n" + infoSupplier.get()));
        }
        return result;
    }

    @NotNull
    public static ActionHint parse(@NotNull PsiFile file, @NotNull String contents) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/quickFix/ActionHint", "parse"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/codeInsight/daemon/quickFix/ActionHint", "parse"));
        }
        PsiFile hostFile = InjectedLanguageManager.getInstance(file.getProject()).getTopLevelFile(file);
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(hostFile.getLanguage());
        String comment = commenter.getLineCommentPrefix();
        if (comment == null) {
            comment = commenter.getBlockCommentPrefix();
        }
        assert (comment != null) : commenter;
        Pattern pattern = Pattern.compile("^" + Pattern.quote(comment) + " \"(.*)\" \"(\\w+)\".*", 32);
        Matcher matcher = pattern.matcher(contents);
        TestCase.assertTrue((String)("No comment found in " + file.getVirtualFile()), (boolean)matcher.matches());
        String text = matcher.group(1);
        String state = matcher.group(2);
        if (state.equals("true") || state.equals("false")) {
            ActionHint actionHint = new ActionHint(text, Boolean.parseBoolean(state), null);
            if (actionHint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/ActionHint", "parse"));
            }
            return actionHint;
        }
        ActionHint actionHint = new ActionHint(text, true, ProblemHighlightType.valueOf(state));
        if (actionHint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/ActionHint", "parse"));
        }
        return actionHint;
    }
}

