/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerEncodingService;
import com.intellij.compiler.ant.ChunkCustomCompilerExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleChunk {
    private final Module[] myModules;
    private final ChunkCustomCompilerExtension[] myCustomCompilers;
    private Module myMainModule;
    private ModuleChunk[] myDependentChunks;
    private File myBaseDir = null;

    public ModuleChunk(Module[] modules) {
        this.myModules = modules;
        Arrays.sort(this.myModules, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        this.myMainModule = this.myModules[0];
        this.myCustomCompilers = ChunkCustomCompilerExtension.getCustomCompile(this);
    }

    public String getName() {
        return this.myMainModule.getName();
    }

    public ChunkCustomCompilerExtension[] getCustomCompilers() {
        return this.myCustomCompilers;
    }

    public Module[] getModules() {
        return this.myModules;
    }

    @Nullable
    public String getOutputDirUrl() {
        return CompilerModuleExtension.getInstance(this.myMainModule).getCompilerOutputUrl();
    }

    @Nullable
    public String getTestsOutputDirUrl() {
        return CompilerModuleExtension.getInstance(this.myMainModule).getCompilerOutputUrlForTests();
    }

    public boolean isJdkInherited() {
        return ModuleRootManager.getInstance(this.myMainModule).isSdkInherited();
    }

    @Nullable
    public Sdk getJdk() {
        return ModuleRootManager.getInstance(this.myMainModule).getSdk();
    }

    public ModuleChunk[] getDependentChunks() {
        return this.myDependentChunks;
    }

    public void setDependentChunks(ModuleChunk[] dependentChunks) {
        this.myDependentChunks = dependentChunks;
    }

    public File getBaseDir() {
        if (this.myBaseDir != null) {
            return this.myBaseDir;
        }
        return new File(this.myMainModule.getModuleFilePath()).getParentFile();
    }

    public void setBaseDir(File baseDir) {
        this.myBaseDir = baseDir;
    }

    public void setMainModule(Module module) {
        this.myMainModule = module;
    }

    public Project getProject() {
        return this.myMainModule.getProject();
    }

    public String getChunkSpecificCompileOptions() {
        StringBuilder options = new StringBuilder();
        Charset encoding = CompilerEncodingService.getInstance(this.getProject()).getPreferredModuleEncoding(this.myMainModule);
        if (encoding != null) {
            ModuleChunk.appendOption(options, "-encoding", encoding.name());
        }
        String languageLevel = ModuleChunk.getLanguageLevelOption(ApplicationManager.getApplication().runReadAction(new Computable<LanguageLevel>(){

            public LanguageLevel compute() {
                return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel(ModuleChunk.this.myMainModule);
            }
        }));
        ModuleChunk.appendOption(options, "-source", languageLevel);
        String bytecodeTarget = CompilerConfiguration.getInstance(this.getProject()).getBytecodeTargetLevel(this.myMainModule);
        if (StringUtil.isEmpty((String)bytecodeTarget)) {
            bytecodeTarget = languageLevel;
        }
        ModuleChunk.appendOption(options, "-target", bytecodeTarget);
        return options.toString();
    }

    public boolean contains(Module module) {
        for (Module chunkModule : this.myModules) {
            if (!chunkModule.equals(module)) continue;
            return true;
        }
        return false;
    }

    private static void appendOption(StringBuilder options, @NotNull String name, @Nullable String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/compiler/ant/ModuleChunk", "appendOption"));
        }
        if (!StringUtil.isEmpty((String)value)) {
            if (options.length() > 0) {
                options.append(" ");
            }
            options.append(name).append(" ").append(value);
        }
    }

    private static String getLanguageLevelOption(LanguageLevel level) {
        return level != null ? level.getCompilerComplianceDefaultOption() : null;
    }
}

