/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileEditorSelectInContext
implements SelectInContext {
    private final FileEditor myFileEditor;
    private final PsiFile myPsiFile;

    public FileEditorSelectInContext(@NotNull FileEditor fileEditor, @NotNull PsiFile psiFile) {
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/ide/FileEditorSelectInContext", "<init>"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/ide/FileEditorSelectInContext", "<init>"));
        }
        this.myFileEditor = fileEditor;
        this.myPsiFile = psiFile;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myPsiFile.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/FileEditorSelectInContext", "getProject"));
        }
        return project;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile2 = this.myPsiFile.getViewProvider().getVirtualFile();
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/FileEditorSelectInContext", "getVirtualFile"));
        }
        return virtualFile2;
    }

    @NotNull
    public FileEditor getFileEditor() {
        FileEditor fileEditor = this.myFileEditor;
        if (fileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/FileEditorSelectInContext", "getFileEditor"));
        }
        return fileEditor;
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/FileEditorSelectInContext", "getPsiFile"));
        }
        return psiFile;
    }

    @Override
    @Nullable
    public Object getSelectorInFile() {
        return ObjectUtils.notNull((Object)this.getElementAtCaret(false), (Object)this.myPsiFile);
    }

    @Nullable
    public PsiElement getElementAtCaret(boolean tryInjected) {
        InjectedLanguageManager manager;
        PsiElement injectedElementAt;
        if (!(this.myFileEditor instanceof TextEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)this.myFileEditor).getEditor();
        int offset = editor.getCaretModel().getOffset();
        if (tryInjected && (injectedElementAt = (manager = InjectedLanguageManager.getInstance(this.getProject())).findInjectedElementAt(this.myPsiFile, offset)) != null) {
            return injectedElementAt;
        }
        return this.myPsiFile.findElementAt(offset);
    }

    @Override
    @Nullable
    public FileEditorProvider getFileEditorProvider() {
        return new FileEditorProvider(){

            @Override
            public FileEditor openFileEditor() {
                return FileEditorSelectInContext.this.myFileEditor;
            }
        };
    }
}

