/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.lib.base85xjava.Base85x;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterInputStream;
import java.util.zip.Inflater;
import org.jetbrains.annotations.NotNull;

public class BinaryEncoder {
    private static char getCharForLineSize(int lineSize) throws BinaryPatchException, Base85x.Base85FormatException {
        BinaryEncoder.checkLenIsValid(lineSize, "Can't encode binary file patch: wrong line size");
        return Base85x.encodeChar(Base85x.decodeChar('A') + lineSize - 1);
    }

    private static int getLineSizeFromChar(char charSize) throws BinaryPatchException, Base85x.Base85FormatException {
        int result = Base85x.decodeChar(charSize) - Base85x.decodeChar('A') + 1;
        BinaryEncoder.checkLenIsValid(result, "Can't decode binary file patch: wrong char-size symbol");
        return result;
    }

    private static void checkLenIsValid(int len, @NotNull String errorMessage) throws BinaryPatchException {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/diff/impl/patch/BinaryEncoder", "checkLenIsValid"));
        }
        if (len < 0 || len > 52) {
            throw new BinaryPatchException(errorMessage);
        }
    }

    public static void encode(@NotNull InputStream input, @NotNull Writer writer) throws IOException, BinaryPatchException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/openapi/diff/impl/patch/BinaryEncoder", "encode"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/openapi/diff/impl/patch/BinaryEncoder", "encode"));
        }
        int maxLineSize = 52;
        byte[] deflated = new byte[maxLineSize];
        try (DeflaterInputStream deflaterStream = new DeflaterInputStream(input);){
            int lineSize;
            do {
                if ((lineSize = deflaterStream.read(deflated, 0, maxLineSize)) <= 0) {
                    break;
                }
                writer.append(BinaryEncoder.getCharForLineSize(lineSize));
                int newSize = (lineSize + 3) / 4 * 4;
                Arrays.fill(deflated, lineSize, newSize, (byte)0);
                writer.append(new String(Base85x.encode(deflated, newSize)));
                writer.append('\n');
            } while (lineSize > 0);
        }
        catch (Base85x.Base85FormatException e) {
            throw new BinaryPatchException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void decode(@NotNull ListIterator<String> input, long size, @NotNull ByteArrayOutputStream byteArrayOutputStream) throws BinaryPatchException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/openapi/diff/impl/patch/BinaryEncoder", "decode"));
        }
        if (byteArrayOutputStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/openapi/diff/impl/patch/BinaryEncoder", "decode"));
        }
        Inflater inflater = new Inflater();
        byte[] inflated = new byte[1024];
        try {
            int count;
            void output;
            String line = input.next();
            while (line != null && line.length() > 0) {
                int len = BinaryEncoder.getLineSizeFromChar(line.charAt(0));
                byte[] toInflate = Base85x.decode(line.substring(1));
                inflater.setInput(toInflate, 0, len);
                while (!inflater.needsInput()) {
                    int resultLength;
                    try {
                        resultLength = inflater.inflate(inflated);
                    }
                    catch (DataFormatException e) {
                        throw new BinaryPatchException("Can't decode binary file patch: can't decompress data");
                    }
                    output.write(inflated, 0, resultLength);
                }
                if (!input.hasNext()) break;
                line = input.next();
            }
            if ((long)(count = output.size()) != size) {
                throw new BinaryPatchException(String.format("%s binary content was decoded than expected", size > (long)count ? "Less" : "More"));
            }
        }
        catch (Base85x.Base85FormatException e) {
            throw new BinaryPatchException(e);
        }
        finally {
            inflater.end();
        }
    }

    public static class BinaryPatchException
    extends Exception {
        BinaryPatchException(String s) {
            super(s);
        }

        BinaryPatchException(Base85x.Base85FormatException e) {
            this(e.getMessage());
        }
    }
}

