/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.settings;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.SystemProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemExecutionSettings
implements Serializable,
UserDataHolder {
    public static final String REMOTE_PROCESS_IDLE_TTL_IN_MS_KEY = "external.system.remote.process.idle.ttl.ms";
    private static final int DEFAULT_REMOTE_PROCESS_TTL_MS = -1;
    private static final long serialVersionUID = 1L;
    private long myRemoteProcessIdleTtlInMs;
    private boolean myVerboseProcessing;
    @NotNull
    private final Set<String> myVmOptions;
    @NotNull
    private final List<String> myArguments;
    @NotNull
    private final Map<String, String> myEnv;
    private boolean myPassParentEnvs = true;
    @NotNull
    private transient UserDataHolderBase myUserData = new UserDataHolderBase();

    public ExternalSystemExecutionSettings() {
        int ttl = SystemProperties.getIntProperty((String)REMOTE_PROCESS_IDLE_TTL_IN_MS_KEY, (int)-1);
        this.setRemoteProcessIdleTtlInMs(ttl);
        this.myVmOptions = new LinkedHashSet<String>();
        this.myArguments = new ArrayList<String>();
        this.myEnv = new LinkedHashMap<String, String>();
    }

    public long getRemoteProcessIdleTtlInMs() {
        return this.myRemoteProcessIdleTtlInMs;
    }

    public void setRemoteProcessIdleTtlInMs(long remoteProcessIdleTtlInMs) {
        this.myRemoteProcessIdleTtlInMs = remoteProcessIdleTtlInMs;
    }

    public boolean isVerboseProcessing() {
        return this.myVerboseProcessing;
    }

    public void setVerboseProcessing(boolean verboseProcessing) {
        this.myVerboseProcessing = verboseProcessing;
    }

    @NotNull
    public Set<String> getVmOptions() {
        Set<String> set = Collections.unmodifiableSet(this.myVmOptions);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings", "getVmOptions"));
        }
        return set;
    }

    @NotNull
    public List<String> getArguments() {
        List<String> list = Collections.unmodifiableList(this.myArguments);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings", "getArguments"));
        }
        return list;
    }

    @NotNull
    public Map<String, String> getEnv() {
        Map<String, String> map = Collections.unmodifiableMap(this.myEnv);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings", "getEnv"));
        }
        return map;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public ExternalSystemExecutionSettings withVmOptions(Collection<String> vmOptions) {
        this.myVmOptions.addAll(vmOptions);
        return this;
    }

    public ExternalSystemExecutionSettings withVmOptions(String ... vmOptions) {
        Collections.addAll(this.myVmOptions, vmOptions);
        return this;
    }

    public ExternalSystemExecutionSettings withVmOption(String vmOption) {
        this.myVmOptions.add(vmOption);
        return this;
    }

    public ExternalSystemExecutionSettings withArguments(Collection<String> arguments) {
        this.myArguments.addAll(arguments);
        return this;
    }

    public ExternalSystemExecutionSettings withArguments(String ... arguments) {
        Collections.addAll(this.myArguments, arguments);
        return this;
    }

    public ExternalSystemExecutionSettings withArgument(String argument) {
        this.myArguments.add(argument);
        return this;
    }

    public ExternalSystemExecutionSettings withEnvironmentVariables(Map<String, String> envs) {
        this.myEnv.putAll(envs);
        return this;
    }

    public ExternalSystemExecutionSettings passParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
        return this;
    }

    @Nullable
    public <U> U getUserData(@NotNull Key<U> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings", "getUserData"));
        }
        return (U)this.myUserData.getUserData(key);
    }

    public <U> void putUserData(@NotNull Key<U> key, U value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/model/settings/ExternalSystemExecutionSettings", "putUserData"));
        }
        this.myUserData.putUserData(key, value);
    }

    public int hashCode() {
        int result = (int)(this.myRemoteProcessIdleTtlInMs ^ this.myRemoteProcessIdleTtlInMs >>> 32);
        result = 31 * result + (this.myVerboseProcessing ? 1 : 0);
        result = 31 * result + this.myVmOptions.hashCode();
        result = 31 * result + this.myArguments.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemExecutionSettings that = (ExternalSystemExecutionSettings)o;
        if (this.myRemoteProcessIdleTtlInMs != that.myRemoteProcessIdleTtlInMs) {
            return false;
        }
        if (this.myVerboseProcessing != that.myVerboseProcessing) {
            return false;
        }
        if (!this.myVmOptions.equals(that.myVmOptions)) {
            return false;
        }
        return this.myArguments.equals(that.myArguments);
    }
}

